<?php
/**
 * Chaty Popups for widget and contact form lead
 *
 * @author  : Premio <contact@premio.io>
 * @license : GPL2
 * */

if (defined('ABSPATH') === false) {
    exit;
}

$showFirstChatyBox = get_option("show_first_chaty_box");
if ($showFirstChatyBox == 1) {
    update_option("show_first_chaty_box", 2);
    ?>
    <div class="first-chaty-popup">
        <div class="first-chaty-popup-overlay"></div>
        <div class="first-chaty-popup-content">
            <div class="first-chaty-popup-data text-center">
                <a href="#" class="close-first-popup">
                    <img src="<?php echo esc_url(CHT_PLUGIN_URL) ?>admin/assets/images/x.svg" alt="chaty" />
                </a>
                <svg width="96" height="100" viewBox="0 0 96 100" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M3.91487 75.0201C3.91487 75.0201 2.56293 75.5676 4.12245 78.438C5.68175 81.3083 6.74738 82.7218 6.74738 82.7218C6.74738 82.7218 7.02805 83.3903 6.46238 83.5096C5.8967 83.6293 4.63976 83.4623 4.40442 84.1644C4.16062 84.8928 4.70222 85.5598 5.78022 86.1291C6.858 86.6987 9.17407 88.0329 9.38273 88.1543C9.58792 88.2734 9.79853 88.5825 9.42633 88.7257C9.05391 88.8692 6.24634 89.2358 6.4999 90.5578C6.75389 91.8794 10.0174 92.9726 10.372 93.099C10.7264 93.225 10.8143 93.3717 10.7906 93.5654C10.767 93.7586 9.81176 93.7931 9.01725 93.9298C8.22296 94.0668 7.32608 94.3651 7.53647 95.1156C7.74686 95.8658 9.70288 97.4032 14.3652 97.7385L16.5355 97.7524L17.6681 95.8897C19.8493 91.7555 19.5793 89.2824 19.0535 88.7068C18.5279 88.1316 17.8007 88.7352 17.264 89.3369C16.7279 89.9383 16.1934 90.7311 16.0169 90.6489C15.8401 90.5667 15.7622 90.4144 15.8425 90.047C15.9227 89.6794 16.7211 86.3313 15.7334 85.417C14.7458 84.5026 12.9495 86.6913 12.631 86.9317C12.3126 87.1718 12.1617 86.8295 12.169 86.5924C12.1764 86.3508 12.2688 83.6799 12.3556 82.4637C12.4423 81.2478 12.1628 80.4353 11.4157 80.2572C10.6954 80.0854 10.1725 81.2406 9.77185 81.6575C9.37102 82.0742 8.9524 81.4827 8.9524 81.4827C8.9524 81.4827 8.31623 79.8308 6.70487 76.9891C5.09351 74.1475 3.88841 75.0329 3.88841 75.0329L3.91487 75.0201Z" fill="#E5E5E4"/>
                    <path d="M16.6781 98.2545C15.503 96.1631 13.4767 92.4108 11.7204 89.1982C9.9646 85.9866 8.37233 83.0803 7.20779 80.9833C6.62541 79.937 6.15387 79.0896 5.82613 78.5009C5.66432 78.2096 5.5383 77.9827 5.45111 77.8257C5.40968 77.75 5.37801 77.6914 5.35502 77.6491C5.33355 77.6094 5.32422 77.588 5.32422 77.588C5.32422 77.588 5.33767 77.607 5.36088 77.6459C5.38517 77.6871 5.419 77.7448 5.46282 77.8192C5.55262 77.9743 5.68254 78.1996 5.84912 78.4881C6.1838 79.0694 6.66228 79.914 7.24943 80.9601C8.4246 83.0517 10.0238 85.9543 11.7794 89.1657C13.5359 92.3784 15.5552 96.1341 16.7198 98.2315" fill="#D7D9D9"/>
                    <path d="M6.15238 84.4734C6.15389 84.4691 6.20812 84.483 6.30464 84.5118C6.4016 84.54 6.54041 84.5854 6.71133 84.6428C7.05317 84.758 7.52102 84.9296 8.03399 85.128C8.53894 85.3256 8.99552 85.5041 9.34494 85.6408C9.50285 85.7015 9.63603 85.7527 9.74318 85.7937C9.83731 85.8293 9.88872 85.8514 9.8872 85.8555C9.8859 85.8601 9.83167 85.8466 9.7345 85.8187C9.63776 85.79 9.49894 85.7449 9.32846 85.6857C8.98793 85.5666 8.52246 85.3894 8.00948 85.1909C7.50345 84.9968 7.04558 84.8218 6.69528 84.6875C6.53716 84.6277 6.40376 84.5773 6.29618 84.5366C6.20226 84.5001 6.15086 84.478 6.15238 84.4734Z" fill="#D7D9D9"/>
                    <path d="M10.0124 85.7046C9.99486 85.6988 10.3057 84.7184 10.7069 83.5155C11.1082 82.3123 11.4477 81.3419 11.4652 81.3477C11.483 81.3536 11.1722 82.3336 10.7709 83.5369C10.3697 84.7399 10.0302 85.7107 10.0124 85.7046Z" fill="#D7D9D9"/>
                    <path d="M12.5003 90.7375C12.4966 90.7347 12.527 90.6863 12.5849 90.6013C12.6515 90.5055 12.7343 90.3855 12.8328 90.2432C13.0415 89.9404 13.3282 89.5214 13.6273 89.0472C13.9277 88.5735 14.1845 88.1356 14.368 87.817C14.4546 87.6671 14.5272 87.5409 14.5858 87.4398C14.6376 87.3509 14.6682 87.3027 14.6723 87.3049C14.6765 87.307 14.6537 87.3593 14.6088 87.4519C14.5639 87.5448 14.4967 87.6777 14.4097 87.8402C14.2366 88.1653 13.9854 88.6084 13.6844 89.0832C13.3842 89.5587 13.0905 89.9747 12.8716 90.271C12.7614 90.4185 12.671 90.5369 12.6061 90.6169C12.5415 90.6972 12.504 90.7404 12.5003 90.7375Z" fill="#D7D9D9"/>
                    <path d="M8.73828 90.4336C8.7385 90.4288 8.79121 90.4286 8.88643 90.4321C8.99574 90.4379 9.13001 90.4451 9.28856 90.4535C9.62801 90.4746 10.0965 90.5082 10.6134 90.5496C11.1307 90.591 11.5986 90.6323 11.9369 90.6654C12.0946 90.6824 12.2284 90.6965 12.3373 90.7082C12.4319 90.7199 12.4837 90.7286 12.4835 90.7329C12.4831 90.7377 12.4304 90.7379 12.3354 90.7344C12.2258 90.7286 12.0916 90.7214 11.933 90.713C11.5938 90.6919 11.1253 90.6583 10.608 90.6169C10.0911 90.5754 9.62324 90.5342 9.28487 90.501C9.12697 90.4841 8.99336 90.47 8.88426 90.4583C8.78991 90.4466 8.73785 90.4379 8.73828 90.4336Z" fill="#D7D9D9"/>
                    <path d="M10.3516 95.1693C10.3518 95.1648 10.4192 95.165 10.5411 95.1695C10.6756 95.176 10.8487 95.1847 11.0567 95.1949C11.4918 95.2196 12.0924 95.258 12.7557 95.3047C13.419 95.3515 14.0194 95.3975 14.4534 95.4344C14.661 95.4532 14.8334 95.4688 14.9674 95.4812C15.0887 95.4938 15.1555 95.5029 15.1553 95.5077C15.1548 95.5122 15.0874 95.5118 14.9657 95.5075C14.8312 95.5005 14.6581 95.492 14.4501 95.4819C14.015 95.4571 13.4142 95.4187 12.7509 95.3721C12.0876 95.3253 11.4875 95.2793 11.0532 95.2426C10.8461 95.2235 10.6732 95.2079 10.5394 95.1956C10.4182 95.1832 10.3511 95.1741 10.3516 95.1693Z" fill="#D7D9D9"/>
                    <path d="M15.0393 95.4455C15.0354 95.4427 15.0723 95.3804 15.1422 95.2705C15.2189 95.1503 15.3191 94.9935 15.44 94.8048C15.6909 94.4118 16.0356 93.8671 16.3989 93.2554C16.7635 92.6438 17.0786 92.0818 17.3042 91.6734C17.4125 91.4771 17.5025 91.3144 17.5714 91.1897C17.635 91.0758 17.6721 91.0138 17.6764 91.0157C17.6805 91.0179 17.6513 91.0841 17.5949 91.2018C17.5383 91.3196 17.4539 91.4888 17.3461 91.6959C17.1311 92.1104 16.8221 92.6774 16.457 93.2899C16.0928 93.9027 15.7412 94.4441 15.4799 94.831C15.3486 95.0243 15.2408 95.1794 15.1638 95.285C15.0873 95.3908 15.043 95.4481 15.0393 95.4455Z" fill="#D7D9D9"/>
                    <path d="M45.9492 17.2493C45.9492 22.6228 50.3052 26.979 55.679 26.979C61.0525 26.979 65.4087 22.6228 65.4087 17.2493C65.4087 11.8758 61.0525 7.51953 55.679 7.51953C50.3052 7.51953 45.9492 11.8758 45.9492 17.2493Z" fill="#E5E5E4"/>
                    <path d="M48.991 17.2292C48.991 20.9301 52.0023 23.9412 55.7035 23.9412C59.4047 23.9412 62.4157 20.9301 62.4157 17.2292C62.4157 13.5279 59.4047 10.5167 55.7035 10.5167C52.0023 10.5167 48.991 13.5279 48.991 17.2292ZM47.6055 17.2292C47.6055 12.7636 51.2381 9.13092 55.7035 9.13092C60.169 9.13092 63.8017 12.7636 63.8017 17.2292C63.8017 21.6945 60.169 25.3272 55.7035 25.3272C51.2381 25.3272 47.6055 21.6945 47.6055 17.2292Z" fill="#F0F0F0"/>
                    <path d="M54.1709 16.9964C54.1709 17.8766 54.8871 18.5928 55.7675 18.5928C56.6479 18.5928 57.3641 17.8766 57.3641 16.9964C57.3641 16.116 56.6479 15.3996 55.7675 15.3996C54.8871 15.3996 54.1709 16.116 54.1709 16.9964ZM52.7852 16.9964C52.7852 15.3516 54.123 14.0138 55.7675 14.0138C57.4121 14.0138 58.7501 15.3516 58.7501 16.9964C58.7501 18.6407 57.4121 19.9788 55.7675 19.9788C54.123 19.9788 52.7852 18.6407 52.7852 16.9964Z" fill="#F0F0F0"/>
                    <path d="M55.7617 16.9923H59.5317L58.8745 18.1553L67.7477 22.2222L67.4486 22.7211L58.5454 18.7017L57.9351 19.8567L55.7617 16.9923Z" fill="#D7D9D9"/>
                    <path d="M67.735 22.2342L67.8293 22.1424C68.2944 21.6893 68.9674 21.5214 69.591 21.7028L73.1304 22.733L71.1594 23.5991L71.9513 25.705L68.6305 24.5207C67.8816 24.2535 67.3962 23.5273 67.4359 22.733L67.735 22.2342Z" fill="#D7D9D9"/>
                    <path d="M10.7079 37.9668C9.78063 38.927 9.80752 40.4571 10.768 41.3841C11.7282 42.3113 13.2582 42.2845 14.1852 41.324C15.1123 40.3638 15.0856 38.8338 14.1252 37.9067C13.1649 36.9797 11.6349 37.0066 10.7079 37.9668ZM9.50711 34.966C9.93289 34.7087 10.3862 34.5135 10.8541 34.3806L11.1315 33.0473L13.384 33.0078L13.7083 34.3302C14.1802 34.4467 14.6403 34.6257 15.075 34.8679L16.2135 34.1218L17.8344 35.6867L17.1286 36.8506C17.386 37.2766 17.5813 37.7302 17.714 38.1978L19.0471 38.4752L19.0868 40.7278L17.7641 41.052C17.6478 41.524 17.4687 41.984 17.2264 42.4187L17.9725 43.5572L16.4078 45.1781L15.2439 44.4723C14.8179 44.7298 14.3644 44.925 13.8968 45.0578L13.6193 46.3908L11.3666 46.4305L11.0426 45.1079C10.5706 44.9914 10.1105 44.8124 9.67586 44.5702L8.53735 45.3163L6.91645 43.7516L7.62225 42.5877C7.36478 42.1617 7.16957 41.7084 7.03683 41.2405L5.70354 40.9631L5.66406 38.7106L6.98672 38.3861C7.10298 37.9141 7.28214 37.4543 7.52442 37.0196L6.77828 35.8811L8.34301 34.2602L9.50711 34.966Z" fill="#D7D9D9"/>
                    <path d="M6.19504 49.7459C5.63999 50.3206 5.65605 51.2366 6.23105 51.7917C6.80584 52.3465 7.72159 52.3305 8.27664 51.7554C8.83148 51.1807 8.81543 50.2647 8.24064 49.7099C7.66585 49.155 6.74988 49.1711 6.19504 49.7459ZM5.47623 47.9495C5.73109 47.7955 6.00244 47.6788 6.28246 47.5992L6.4486 46.801L7.79686 46.7773L7.99099 47.569C8.27361 47.6387 8.54907 47.746 8.80914 47.8909L9.49064 47.4443L10.4608 48.3809L10.0385 49.0776C10.1925 49.3327 10.3094 49.6042 10.389 49.8842L11.1868 50.0502L11.2107 51.3986L10.419 51.5928C10.3491 51.8752 10.242 52.1506 10.0971 52.4107L10.5437 53.0924L9.60712 54.0626L8.91043 53.6401C8.65535 53.7943 8.38379 53.911 8.10377 53.9904L7.93784 54.7886L6.58937 54.8122L6.39524 54.0205C6.11284 53.9509 5.83737 53.8436 5.57709 53.6984L4.89559 54.1453L3.92539 53.2087L4.34791 52.512C4.19392 52.2569 4.07701 51.9856 3.9974 51.7056L3.19942 51.5394L3.17578 50.1912L3.96747 49.997C4.0371 49.7144 4.14424 49.4389 4.28935 49.1789L3.84275 48.4974L4.77933 47.5272L5.47623 47.9495Z" fill="#E5E5E4"/>
                    <path d="M6.19324 49.7356C6.19324 49.7356 6.26893 49.6289 6.46263 49.4992C6.65263 49.3725 6.98492 49.2316 7.40636 49.276C7.61372 49.2994 7.84081 49.3671 8.04774 49.504C8.25249 49.6408 8.44597 49.8356 8.56656 50.0885C8.63012 50.2126 8.67436 50.3505 8.69822 50.4946C8.72425 50.6382 8.72794 50.7893 8.70647 50.9401C8.66981 51.242 8.52687 51.5398 8.30476 51.7739C8.07854 52.0044 7.78594 52.1578 7.4851 52.2051C7.33544 52.2319 7.18426 52.2333 7.03958 52.2126C6.89491 52.1936 6.75544 52.1543 6.62921 52.0953C6.37218 51.9834 6.17068 51.7971 6.02687 51.5973C5.88263 51.3951 5.80693 51.1706 5.77657 50.9642C5.71735 50.5445 5.84641 50.2076 5.96636 50.013C6.08934 49.815 6.19324 49.7356 6.19324 49.7356C6.20104 49.7424 6.10582 49.8306 5.99434 50.0291C5.88545 50.2243 5.77006 50.5536 5.83448 50.9553C5.86745 51.1531 5.94293 51.3665 6.08283 51.5574C6.22252 51.7461 6.41578 51.9216 6.66022 52.0255C6.7806 52.0806 6.9127 52.1168 7.04999 52.1339C7.18708 52.153 7.33001 52.151 7.47143 52.1248C7.75579 52.0793 8.03125 51.9339 8.24512 51.7164C8.45464 51.4951 8.59021 51.2147 8.62578 50.929C8.64703 50.787 8.644 50.6438 8.62014 50.5074C8.59823 50.3712 8.55745 50.2401 8.49802 50.1222C8.38567 49.8814 8.20347 49.6944 8.01 49.5615C7.81435 49.4283 7.59854 49.3604 7.39964 49.3344C6.99577 49.284 6.67085 49.4109 6.47954 49.5265C6.28498 49.645 6.19996 49.7432 6.19324 49.7356Z" fill="#E5E5E4"/>
                    <path d="M5.50617 47.9257C5.50617 47.9268 5.49098 47.919 5.46105 47.9021C5.4283 47.883 5.38449 47.8578 5.32744 47.8249C5.20554 47.7528 5.03029 47.6492 4.80232 47.5147L4.81881 47.5125C4.58043 47.7624 4.26679 48.0908 3.88765 48.4881L3.89025 48.4621C4.02625 48.668 4.17765 48.8968 4.33967 49.1417L4.3477 49.154L4.34054 49.1668C4.20801 49.4067 4.09696 49.68 4.02386 49.9796L4.01996 49.9956L4.00391 49.9995C3.75729 50.0609 3.4905 50.127 3.21265 50.196L3.23521 50.1667C3.24367 50.5914 3.25256 51.0419 3.26189 51.515L3.23608 51.4838C3.48313 51.5345 3.75534 51.5907 4.03428 51.6482L4.05466 51.6523L4.0603 51.6725C4.13448 51.9325 4.25031 52.2095 4.40843 52.4696L4.41971 52.4882L4.40843 52.5069C4.27786 52.7229 4.13362 52.9611 3.98699 53.204L3.98114 53.1582C4.2861 53.4521 4.61514 53.769 4.95242 54.0937L4.90448 54.0894C5.11661 53.9499 5.34956 53.797 5.58555 53.6419L5.60551 53.6289L5.62633 53.6404C5.86427 53.7732 6.14212 53.8862 6.43472 53.9577L6.45836 53.9636L6.46422 53.9872C6.52517 54.2351 6.59176 54.5056 6.65878 54.7787L6.61865 54.7479C7.04551 54.7403 7.50318 54.7321 7.96691 54.7234L7.92743 54.7564C7.97971 54.5043 8.03632 54.2323 8.09336 53.9584L8.09835 53.9337L8.12264 53.9269C8.38813 53.8519 8.66316 53.7358 8.91802 53.5814L8.91889 53.581L8.94058 53.568L8.96162 53.581C9.19565 53.7226 9.42817 53.8638 9.6583 54.0033L9.60712 54.01C9.92379 53.6823 10.2361 53.3587 10.5441 53.04L10.5391 53.091C10.389 52.8615 10.2402 52.6344 10.093 52.4095L10.0795 52.3887L10.0915 52.3672C10.2346 52.1108 10.3411 51.8377 10.4099 51.5595L10.4157 51.5356L10.4394 51.53C10.707 51.4645 10.9708 51.4 11.2311 51.3365L11.2009 51.3755C11.1933 50.9153 11.1859 50.4656 11.1786 50.0273L11.2091 50.0639C10.9385 50.0071 10.6725 49.9514 10.4112 49.8967L10.389 49.8921L10.383 49.8705C10.3023 49.5846 10.1843 49.3161 10.0377 49.0725L10.0264 49.0538L10.0377 49.0354C10.183 48.7966 10.3238 48.5654 10.4613 48.3393L10.4669 48.3821C10.1262 48.052 9.80471 47.74 9.49845 47.4433L9.53792 47.447C9.29803 47.6036 9.07267 47.7505 8.85555 47.8921L8.84037 47.9019L8.82454 47.8932C8.55298 47.7413 8.28077 47.6385 8.01441 47.5717L7.99836 47.5678L7.99446 47.5518C7.92483 47.2637 7.86215 47.0045 7.80293 46.7594L7.82723 46.7781C7.30493 46.785 6.85985 46.7909 6.47875 46.7959L6.49675 46.7811C6.42843 47.0995 6.37225 47.3605 6.3254 47.578L6.32388 47.586L6.31608 47.5882C6.03063 47.6678 5.83 47.7609 5.69943 47.8255C5.63718 47.858 5.58946 47.8828 5.55432 47.9012C5.52157 47.9192 5.50617 47.9268 5.50617 47.9257C5.50617 47.9246 5.52135 47.914 5.55107 47.8951C5.58187 47.8763 5.6285 47.8476 5.69314 47.8134C5.82219 47.7446 6.02239 47.6468 6.3087 47.5626L6.29937 47.5726C6.34319 47.3546 6.39611 47.0926 6.46031 46.7735L6.46313 46.759L6.47832 46.7586C6.8592 46.7503 7.30406 46.7406 7.82636 46.7291L7.84588 46.7286L7.85065 46.7477C7.9116 46.9924 7.9758 47.2514 8.04738 47.5388L8.02764 47.5188C8.29877 47.585 8.57618 47.6878 8.8536 47.8411L8.8228 47.8422C9.03949 47.6997 9.26398 47.5518 9.50322 47.3939L9.52448 47.38L9.5427 47.3978C9.84983 47.6932 10.1728 48.0036 10.5146 48.3324L10.5346 48.3515L10.5203 48.3751C10.3834 48.6016 10.2435 48.8334 10.099 49.0725V49.0354C10.2498 49.2837 10.3713 49.5581 10.4545 49.8503L10.4264 49.824C10.6877 49.878 10.9539 49.9331 11.2245 49.9891L11.2545 49.9954L11.2551 50.0258C11.2632 50.4643 11.2716 50.9137 11.2801 51.374L11.2807 51.4057L11.2499 51.4133C10.9896 51.4773 10.7261 51.5419 10.4585 51.6078L10.4877 51.5785C10.4177 51.864 10.309 52.1438 10.1624 52.4069L10.1611 52.3646C10.3086 52.5897 10.4574 52.8166 10.6079 53.0459L10.6259 53.0734L10.6031 53.0971C10.2953 53.4159 9.98322 53.7395 9.66676 54.0675L9.64377 54.0913L9.61536 54.074C9.38501 53.9345 9.15271 53.7935 8.91889 53.6519H8.96162L8.96097 53.6523C8.69938 53.8105 8.41741 53.9295 8.1452 54.0065L8.17427 53.9751C8.11722 54.2492 8.06061 54.5212 8.00812 54.7733L8.0014 54.8054L7.96843 54.806C7.50448 54.8138 7.04703 54.8219 6.61995 54.8292L6.58742 54.8297L6.57983 54.798C6.51302 54.5247 6.44687 54.2542 6.38635 54.0063L6.41563 54.0358C6.11588 53.9621 5.8313 53.8456 5.58794 53.7094L5.62872 53.7079C5.39251 53.8625 5.15934 54.015 4.94678 54.1538L4.92097 54.1709L4.89884 54.1493C4.56243 53.8237 4.23404 53.5059 3.92973 53.2114L3.90847 53.1908L3.92387 53.1656C4.07115 52.9233 4.21604 52.6854 4.34726 52.4696V52.5067C4.18632 52.2403 4.0692 51.9573 3.99437 51.6911L4.02039 51.7152C3.74168 51.6566 3.46968 51.5996 3.22263 51.5475L3.19725 51.5421L3.19682 51.5161C3.18945 51.0432 3.18251 50.5925 3.176 50.1678L3.17578 50.1442L3.19856 50.1385C3.47662 50.0713 3.74406 50.0064 3.9909 49.9468L3.97094 49.9665C4.04707 49.6622 4.16181 49.3857 4.29803 49.1432L4.2989 49.1683C4.13904 48.9222 3.98938 48.692 3.8549 48.4851L3.84579 48.471L3.8575 48.4589C4.2412 48.0661 4.55831 47.7411 4.79972 47.4941L4.80731 47.4865L4.81599 47.4921C5.03875 47.6305 5.21031 47.7372 5.32939 47.8114C5.38557 47.847 5.42895 47.8745 5.46149 47.8953C5.49098 47.9142 5.50617 47.9246 5.50617 47.9257Z" fill="#E5E5E4"/>
                    <path d="M82.2773 45.2573L82.3049 41.6992L85.7367 42.5302L82.2773 45.2573Z" fill="#F0F0F0"/>
                    <path d="M89.5554 49.2428L87.9798 50.485L82.957 44.1133L84.5328 42.8713L89.5554 49.2428Z" fill="#F0F0F0"/>
                    <path d="M77.7852 53.9357L78.2671 46.7287L85.1221 48.824L77.7852 53.9357Z" fill="#E5E5E4"/>
                    <path d="M92.0535 62.9764L88.7119 65.3046L79.2969 51.7915L82.6382 49.463L92.0535 62.9764Z" fill="#E5E5E4"/>
                    <path d="M95.244 97.8594C95.244 97.8907 74.0523 97.9158 47.917 97.9158C21.7728 97.9158 0.585938 97.8907 0.585938 97.8594C0.585938 97.8282 21.7728 97.8028 47.917 97.8028C74.0523 97.8028 95.244 97.8282 95.244 97.8594Z" fill="#0C2B34"/>
                    <path d="M71.9191 88.4788C72.3715 88.6315 72.7268 89.0076 72.9257 89.4418C73.1246 89.8758 73.1806 90.3636 73.1669 90.841C73.1404 91.7646 72.6988 92.732 72.2008 93.5102C71.3736 92.9029 71.0974 91.7453 70.994 91.149C70.8309 90.2068 71.1079 88.4048 71.9191 88.4788Z" fill="#335863"/>
                    <path d="M73.2095 94.9381C73.0423 94.4316 73.2097 93.8462 73.5765 93.4592C73.9435 93.0721 74.4855 92.8753 75.0189 92.8712C75.2653 92.8693 75.5362 92.9183 75.6937 93.1083C75.841 93.2857 75.8483 93.5503 75.7592 93.7629C75.6698 93.9755 75.4985 94.1433 75.3143 94.2819C74.6823 94.757 73.9832 95.101 73.2095 94.9381Z" fill="#335863"/>
                    <path d="M72.4627 97.8162C72.4579 97.8156 72.4631 97.7479 72.4744 97.6262C72.4874 97.492 72.5041 97.3187 72.5245 97.1104C72.574 96.6786 72.6317 96.0613 72.9117 95.4431C73.1874 94.8267 73.6062 94.3547 73.9717 94.107C74.153 93.9808 74.314 93.9009 74.4287 93.8569C74.4853 93.8322 74.5322 93.8209 74.5625 93.8105C74.5935 93.8012 74.6102 93.7973 74.6109 93.7997C74.6176 93.814 74.3495 93.886 73.9994 94.1454C73.6478 94.3983 73.2438 94.8646 72.9726 95.4707C72.6983 96.076 72.6328 96.6855 72.5716 97.1159C72.543 97.3328 72.5198 97.5085 72.5002 97.6293C72.4809 97.7505 72.467 97.8167 72.4627 97.8162Z" fill="#0C2B34"/>
                    <path d="M71.8255 89.8439C71.8278 89.8437 71.8333 89.8716 71.8417 89.9252C71.8504 89.9857 71.8617 90.0634 71.8756 90.1597C71.904 90.3636 71.9411 90.659 71.984 91.0245C72.0695 91.7554 72.1738 92.767 72.2638 93.8865C72.3534 95.0061 72.4115 96.0216 72.4434 96.7569C72.4595 97.1246 72.4699 97.4222 72.4744 97.6278C72.4759 97.7252 72.4772 97.8037 72.4783 97.8649C72.4785 97.9191 72.4775 97.9475 72.4751 97.9477C72.4727 97.9477 72.4692 97.9195 72.4647 97.8655C72.4605 97.8044 72.4549 97.7258 72.4484 97.6291C72.4356 97.4155 72.4178 97.1203 72.3961 96.7593C72.3521 96.0251 72.2864 95.0109 72.197 93.8919C72.107 92.7731 72.0105 91.7615 71.9367 91.0295C71.9007 90.6698 71.8712 90.3757 71.8498 90.1627C71.8409 90.0658 71.8339 89.9877 71.8285 89.9265C71.8242 89.8725 71.8231 89.8441 71.8255 89.8439Z" fill="#0C2B34"/>
                    <path d="M71.9238 95.5835C71.6551 94.4916 70.8246 93.5539 69.7731 93.1552C69.5052 93.0537 69.1623 93.0017 68.9669 93.211C68.7712 93.4205 68.8476 93.7608 68.9738 94.0183C69.4989 95.0904 70.724 95.7748 71.9119 95.6605" fill="#335863"/>
                    <path d="M69.9727 94.0436C69.9745 94.039 70.0346 94.0599 70.1421 94.1011C70.1964 94.121 70.2623 94.1464 70.3354 94.1837C70.4083 94.221 70.4953 94.2562 70.5831 94.3112C70.672 94.3635 70.7712 94.4188 70.869 94.4911C70.9711 94.5576 71.0718 94.6398 71.1774 94.727C71.3837 94.9064 71.5945 95.1238 71.7804 95.3801C71.9641 95.6378 72.104 95.9068 72.2073 96.1601C72.2552 96.2883 72.3008 96.4102 72.3296 96.5288C72.3656 96.6451 72.3849 96.757 72.404 96.8583C72.427 96.9594 72.43 97.0535 72.4402 97.1349C72.4511 97.2162 72.4517 97.2867 72.4519 97.3446C72.4532 97.46 72.4517 97.5233 72.4469 97.5233C72.432 97.5242 72.4365 97.268 72.3576 96.8672C72.3357 96.7674 72.3142 96.6581 72.2763 96.544C72.2459 96.428 72.1986 96.3087 72.1502 96.1831C72.0455 95.9354 71.9064 95.6725 71.7262 95.4192C71.5433 95.1678 71.3377 94.9528 71.1369 94.7737C71.0343 94.6867 70.9362 94.6041 70.8369 94.5364C70.7419 94.4631 70.6456 94.4067 70.559 94.3522C70.2081 94.1431 69.9673 94.0568 69.9727 94.0436Z" fill="#0C2B34"/>
                    <path d="M74.0814 36.6061L76.6168 35.1674C77.6499 35.8038 78.8663 36.1717 80.1686 36.1717C83.9142 36.1717 86.9506 33.1353 86.9506 29.3896C86.9506 25.6439 83.9142 22.6075 80.1686 22.6075C76.4231 22.6075 73.3867 25.6439 73.3867 29.3896C73.3867 30.9537 73.9175 32.393 74.807 33.5402L74.8037 33.5378L74.0814 36.6061Z" fill="white"/>
                    <path d="M74.0738 36.6068C74.1176 36.4125 74.331 35.4692 74.7687 33.5323L74.7783 33.4897L74.8132 33.5162L74.8165 33.5186L74.777 33.5581C74.1753 32.7911 73.5892 31.6864 73.4003 30.2996C73.3558 29.9547 73.3274 29.5942 73.3452 29.2237C73.3554 29.0387 73.36 28.8502 73.3756 28.6602C73.4042 28.4715 73.4331 28.28 73.4623 28.0861C73.6137 27.3165 73.9055 26.5296 74.3605 25.7956C74.8141 25.0618 75.4303 24.3825 76.1873 23.8376C76.9432 23.2939 77.8392 22.8813 78.8135 22.6883C79.7861 22.497 80.8288 22.5126 81.8378 22.7681C82.8433 23.0253 83.8259 23.506 84.6341 24.2252C85.4596 24.9532 86.1205 25.8531 86.5042 26.845C86.8961 27.8327 87.0454 28.886 86.9721 29.8924C86.8994 30.8995 86.6103 31.863 86.1448 32.6894C85.683 33.5184 85.0666 34.2172 84.3781 34.7564C83.6895 35.2974 82.9299 35.6783 82.1738 35.914C81.414 36.1481 80.6607 36.211 79.9633 36.2079C78.5591 36.1674 77.4063 35.6961 76.5951 35.1911L76.6226 35.1915C75.0121 36.0858 74.2401 36.5144 74.0738 36.6068C74.2382 36.5114 75.0021 36.0685 76.5959 35.1445L76.6096 35.1367L76.6235 35.1449C77.4327 35.6386 78.5771 36.0969 79.9657 36.1299C80.6552 36.1292 81.399 36.0637 82.1477 35.8297C82.8932 35.5941 83.6409 35.2156 84.3183 34.6805C84.9957 34.1467 85.6012 33.4566 86.0539 32.6393C86.5109 31.8246 86.7936 30.8759 86.8636 29.8846C86.9343 28.8936 86.7864 27.8579 86.4003 26.8868C86.0225 25.9112 85.372 25.0267 84.5601 24.3107C83.7652 23.6027 82.7993 23.1303 81.8105 22.8765C80.8181 22.6247 79.792 22.608 78.8346 22.795C77.8761 22.9837 76.9933 23.3882 76.2478 23.9222C75.5012 24.4571 74.8924 25.1249 74.4434 25.8468C73.9924 26.5693 73.702 27.3441 73.5498 28.103C73.52 28.2943 73.491 28.4832 73.4621 28.6695C73.4459 28.8569 73.4406 29.043 73.4296 29.2259C73.4101 29.5918 73.4368 29.948 73.479 30.2891C73.6589 31.6606 74.2313 32.7577 74.8215 33.5236L74.9551 33.6967L74.7822 33.5633L74.7792 33.5609L74.8236 33.545C74.351 35.474 74.1211 36.4134 74.0738 36.6068Z" fill="#0C2B34"/>
                    <path d="M79.0508 28.8053H79.4475L80.3134 27.5987V26.8068C80.3134 26.8068 80.9265 26.7691 80.8543 27.8061C80.7821 28.8431 80.8604 28.5791 80.8604 28.5791C80.8604 28.5791 82.1624 28.5839 82.2707 28.6971C82.3492 28.7793 82.3848 30.0727 82.3984 30.7741C82.4054 31.1273 82.1887 31.4557 81.8603 31.5392C81.8137 31.5511 81.7664 31.558 81.7202 31.558C81.3953 31.558 79.7362 31.2941 79.7362 31.2941H79.0508V28.8053Z" fill="#DE5757"/>
                    <path d="M77.9297 28.5645L78.1735 31.2779H78.8528V28.619L77.9297 28.5645Z" fill="#DE5757"/>
                    <path d="M24.4281 40.7229L21.1716 41.9165L19.4555 45.5309C19.3759 46.2768 17.501 53.8087 17.501 53.8087L15.625 60.5144C19.2164 62.1555 23.9802 64.4981 28.7508 64.3091L29.3633 58.5578L32.635 46.0571L30.1378 41.0977L29.2843 40.9834L24.4281 40.7229Z" fill="#DE5757"/>
                    <path d="M9.27924 89.7712L6.82804 92.9694C6.82804 92.9694 9.2556 96.535 8.86018 97.1703L2.48828 92.6401L6.10316 87.5L9.27924 89.7712Z" fill="#335863"/>
                    <path d="M4.97157 91.8524C4.93665 91.8524 4.9026 91.8468 4.87201 91.8351C4.72561 91.7784 4.64796 91.591 4.70782 91.4461C4.75489 91.3323 4.87809 91.2598 5.0002 91.2598C5.02406 91.2598 5.04814 91.2624 5.07134 91.2683C5.22599 91.2895 5.32837 91.5036 5.28521 91.6539C5.25094 91.773 5.10388 91.8524 4.97157 91.8524Z" fill="#A6B6BB"/>
                    <path d="M8.86019 97.1572L2.48828 92.627L8.86019 97.1572C8.91723 97.0654 8.9155 96.9127 8.87081 96.7184C8.91788 96.8218 8.98686 97.0286 8.86019 97.1572Z" fill="white"/>
                    <path d="M8.86018 97.1727L2.48828 92.6425L2.87285 92.1387L8.83849 96.6706C8.83849 96.6706 8.85302 96.6949 8.87081 96.7339C8.91549 96.9283 8.91723 97.081 8.86018 97.1727Z" fill="#A6B6BB"/>
                    <path d="M6.98618 92.9822C6.96298 93.0126 6.79726 92.9163 6.57299 92.9072C6.34915 92.8927 6.17432 92.9712 6.15459 92.9386C6.13008 92.9122 6.3088 92.7592 6.58015 92.7746C6.85149 92.7877 7.01308 92.9586 6.98618 92.9822Z" fill="#0C2B34"/>
                    <path d="M7.4418 93.7527C7.42748 93.7879 7.25505 93.7451 7.05572 93.8015C6.85487 93.8521 6.72711 93.9755 6.69718 93.9521C6.66421 93.9362 6.77244 93.7389 7.02145 93.6731C7.2698 93.6055 7.46219 93.7226 7.4418 93.7527Z" fill="#0C2B34"/>
                    <path d="M7.28534 94.8247C7.25237 94.8113 7.31961 94.6252 7.52046 94.5113C7.72088 94.3963 7.91544 94.4334 7.91001 94.4688C7.90936 94.507 7.74994 94.531 7.5864 94.6271C7.42047 94.7186 7.31831 94.8438 7.28534 94.8247Z" fill="#0C2B34"/>
                    <path d="M7.47298 92.206C7.4398 92.225 7.32766 92.0808 7.14329 91.9676C6.9611 91.8507 6.78237 91.8123 6.78519 91.7741C6.78324 91.7388 6.99862 91.7188 7.21379 91.855C7.43026 91.9895 7.50574 92.1923 7.47298 92.206Z" fill="#0C2B34"/>
                    <path d="M7.76169 91.8629L7.71484 91.829L8.15125 91.2599L8.19788 91.2922L7.76169 91.8629Z" fill="#999C9D"/>
                    <path d="M7.70131 91.8625L4.63672 89.6414L5.00762 89.1113L8.13772 91.2934L7.70131 91.8625Z" fill="#193A42"/>
                    <path d="M7.91365 91.5568C7.90497 91.57 7.76833 91.5017 7.59567 91.3282C7.51 91.2419 7.4176 91.128 7.33474 90.9883C7.29353 90.9187 7.2547 90.8423 7.22065 90.7608C7.20482 90.7211 7.18356 90.6773 7.1777 90.6172C7.16643 90.5602 7.20525 90.4639 7.28117 90.4417C7.34862 90.4157 7.42128 90.4357 7.46813 90.4675C7.51607 90.4992 7.5473 90.5359 7.57593 90.5688C7.63471 90.6367 7.68438 90.7074 7.72603 90.7781C7.80845 90.9202 7.85747 91.0603 7.88285 91.1805C7.93339 91.4226 7.90129 91.5746 7.88632 91.5731C7.86485 91.5733 7.86224 91.4247 7.79218 91.2048C7.75705 91.0953 7.7026 90.9688 7.62148 90.8419C7.58071 90.7788 7.53321 90.7157 7.47855 90.6554C7.42367 90.5894 7.36641 90.5484 7.3278 90.566C7.31348 90.573 7.30936 90.5771 7.30936 90.6066C7.3111 90.6352 7.32563 90.6725 7.34146 90.712C7.37161 90.7888 7.40567 90.861 7.44146 90.9282C7.51347 91.0623 7.59285 91.1755 7.66595 91.2655C7.81214 91.4464 7.92623 91.5403 7.91365 91.5568Z" fill="#0C2B34"/>
                    <path d="M7.86743 91.5487C7.85312 91.5458 7.87069 91.3905 8.00256 91.1808C8.06828 91.0771 8.16459 90.9632 8.29451 90.8622C8.35937 90.8123 8.43268 90.7657 8.51337 90.7264C8.59557 90.69 8.70098 90.6381 8.83156 90.7099C8.89641 90.7524 8.91377 90.839 8.90162 90.8938C8.89208 90.9518 8.86974 90.9917 8.8513 91.034C8.81009 91.1168 8.75673 91.1886 8.6986 91.2491C8.58212 91.3704 8.44634 91.4439 8.32791 91.4819C8.08607 91.5584 7.92968 91.5033 7.93446 91.491C7.93532 91.4678 8.0865 91.4849 8.29451 91.394C8.39711 91.3491 8.51228 91.2758 8.60858 91.1661C8.65695 91.1114 8.70055 91.0483 8.73395 90.9776C8.77213 90.9025 8.78558 90.8299 8.75521 90.8188C8.72398 90.7958 8.63396 90.8084 8.56933 90.844C8.49601 90.8778 8.42834 90.9177 8.36739 90.9606C8.24549 91.0474 8.14984 91.1452 8.07913 91.2352C7.93749 91.4159 7.88782 91.5563 7.86743 91.5487Z" fill="#0C2B34"/>
                    <path d="M28.7054 91.8947L27.2917 95.4488C27.2917 95.4488 31.3484 96.9155 31.4 97.662L23.582 97.7249L24.801 91.9157L28.7054 91.8947Z" fill="#335863"/>
                    <path d="M24.9115 95.7246C24.7792 95.7246 24.6478 95.6279 24.6168 95.4973C24.5825 95.3542 24.6712 95.1948 24.807 95.1403C24.8367 95.1245 24.8697 95.1173 24.9037 95.1173C25.0276 95.1173 25.1649 95.2121 25.2063 95.3273C25.2596 95.475 25.1293 95.6765 24.9777 95.7162C24.956 95.722 24.9336 95.7246 24.9115 95.7246Z" fill="#A6B6BB"/>
                    <path d="M23.582 97.7501L31.4 97.6872C31.3927 97.5794 31.3016 97.4564 31.151 97.325C31.2499 97.3812 31.4274 97.5087 31.4 97.6872L23.582 97.7501ZM23.582 97.7501L23.7146 97.1191L23.582 97.7501Z" fill="white"/>
                    <path d="M23.582 97.7501L23.7146 97.1191L31.0881 97.2929C31.0881 97.2929 31.1141 97.3039 31.151 97.325C31.3015 97.4564 31.3926 97.5794 31.4 97.6872L23.582 97.7501Z" fill="#A6B6BB"/>
                    <path d="M27.4163 95.4444C27.4152 95.4828 27.2245 95.5015 27.0378 95.6258C26.8475 95.7453 26.7521 95.9114 26.7167 95.8965C26.6816 95.8893 26.7367 95.6607 26.9655 95.5143C27.1931 95.3657 27.4241 95.4093 27.4163 95.4444Z" fill="#0C2B34"/>
                    <path d="M28.1978 95.767C28.2067 95.8039 28.0418 95.8702 27.9136 96.0329C27.7805 96.1917 27.7492 96.3663 27.7113 96.365C27.6753 96.3715 27.6471 96.1479 27.8106 95.9488C27.9722 95.7486 28.1967 95.7308 28.1978 95.767Z" fill="#0C2B34"/>
                    <path d="M28.7071 96.7548C28.6726 96.7632 28.618 96.5728 28.7143 96.3631C28.8091 96.1524 28.9884 96.0685 29.0049 96.1002C29.0264 96.1314 28.9114 96.2446 28.8353 96.4181C28.7548 96.5897 28.7451 96.7509 28.7071 96.7548Z" fill="#0C2B34"/>
                    <path d="M27.7148 94.7144C27.6989 94.7493 27.5235 94.6979 27.3076 94.7144C27.0918 94.7263 26.9244 94.8003 26.9044 94.7677C26.8819 94.7402 27.0448 94.5975 27.299 94.5819C27.5532 94.5641 27.7332 94.6842 27.7148 94.7144Z" fill="#0C2B34"/>
                    <path d="M27.7552 94.2253C27.7557 94.2414 27.6049 94.2661 27.3635 94.2266C27.2433 94.2067 27.1017 94.1687 26.9527 94.1041C26.8785 94.0715 26.8024 94.0327 26.7271 93.9865C26.6909 93.9635 26.6479 93.9408 26.608 93.8954C26.5655 93.8559 26.5406 93.7549 26.5889 93.6924C26.6284 93.6321 26.6991 93.6056 26.7555 93.6039C26.813 93.6015 26.8599 93.6128 26.9024 93.623C26.9898 93.6434 27.0716 93.6716 27.1466 93.7045C27.2965 93.7714 27.4186 93.8562 27.5095 93.9386C27.6923 94.1052 27.7554 94.2472 27.7422 94.2546C27.7251 94.2674 27.6359 94.1488 27.4503 94.0115C27.3576 93.9431 27.2394 93.8729 27.0995 93.8173C27.0293 93.7902 26.9538 93.7668 26.8742 93.7501C26.7911 93.7288 26.7208 93.7288 26.6996 93.7659C26.6922 93.7802 26.6911 93.7857 26.7087 93.8095C26.7267 93.8319 26.7605 93.8533 26.7961 93.8763C26.8655 93.9208 26.9356 93.9594 27.0039 93.9928C27.141 94.0594 27.2717 94.1045 27.3837 94.1347C27.6079 94.1956 27.7554 94.205 27.7552 94.2253Z" fill="#0C2B34"/>
                    <path d="M27.7451 94.2136C27.7316 94.2197 27.6548 94.0835 27.6388 93.8364C27.6314 93.7139 27.6427 93.5651 27.6887 93.4072C27.7121 93.3287 27.7442 93.248 27.7867 93.1688C27.8318 93.0912 27.8869 92.9873 28.0349 92.969C28.1121 92.9653 28.1769 93.0254 28.1993 93.0768C28.2255 93.1295 28.2309 93.1749 28.2405 93.2202C28.2557 93.3113 28.2546 93.4009 28.2431 93.4837C28.2197 93.6505 28.1526 93.7894 28.0789 93.8896C27.9277 94.0937 27.7689 94.1403 27.7655 94.1275C27.7527 94.1084 27.8852 94.0336 28.0004 93.8379C28.0574 93.7414 28.1075 93.6147 28.1214 93.4692C28.1286 93.3968 28.1266 93.3198 28.1125 93.243C28.0995 93.1599 28.0676 93.0931 28.0366 93.1018C27.9978 93.1016 27.9323 93.1647 27.9008 93.2313C27.8611 93.3015 27.8299 93.3736 27.8054 93.4443C27.7577 93.5859 27.7375 93.7215 27.7329 93.8356C27.724 94.0652 27.7659 94.2077 27.7451 94.2136Z" fill="#0C2B34"/>
                    <path d="M37.814 27.834L36.6124 36.0059L31.1055 41.2842L33.1454 44.8002L39.3965 38.9638C39.8683 38.6059 40.2001 38.0943 40.3346 37.5177L40.3359 29.0697L40.2947 26.3185L37.814 27.834Z" fill="#FCCBB6"/>
                    <path d="M15.7801 59.9121C15.6194 60.2333 12.6606 75.5945 12.6606 75.5945L4.39453 89.0443L8.69113 92.1733L18.9041 78.8634L24.4887 61.9469L15.7801 59.9121Z" fill="#0C2B34"/>
                    <path d="M27.0128 61.5199C27.2535 61.6806 33.5773 74.8749 33.497 75.8384C33.4165 76.8021 28.6488 94.4171 28.6488 94.4171L23.7926 93.5226L26.8015 76.3379L21.0938 68.3256L22.9571 61.0351L27.0128 61.5199Z" fill="#0C2B34"/>
                    <path d="M33.6534 38.379L30.5194 40.982L29.9336 41.0742L32.2946 46.2876L36.6445 42.7749L33.6534 38.379Z" fill="#DE5757"/>
                    <path d="M24.4281 40.7229L21.1716 41.9165L19.4555 45.5309C19.3759 46.2768 17.501 53.8087 17.501 53.8087L15.625 60.5144C19.2164 62.1555 23.9802 64.4981 28.7508 64.3091L29.3633 58.5578L32.6647 45.9437L30.1378 41.0977L29.2843 40.9834L24.4281 40.7229Z" fill="#DE5757"/>
                    <path d="M29.2302 41.7444C29.3087 41.1428 29.3753 40.6408 29.3874 40.5795C29.3874 40.5795 31.4473 40.6552 31.8586 38.6603C32.0573 37.6964 32.305 35.6775 32.5078 33.8486C32.7257 31.8841 31.3961 30.0825 29.4555 29.7075L29.2627 29.6702C27.159 29.3895 25.7452 31.0195 25.5229 33.1304L24.5117 40.8367C24.5117 40.8367 26.4608 42.5769 27.5976 43.1367C29.0671 43.8603 29.2302 41.7444 29.2302 41.7444Z" fill="#FCCBB6"/>
                    <path d="M29.3661 40.5512C29.3661 40.5512 28.0825 40.4098 26.9023 39.3066C26.9023 39.3066 27.2405 40.8646 29.2705 41.0703L29.3661 40.5512Z" fill="#F8A891"/>
                    <path d="M31.9954 34.7823C31.9531 34.817 31.6835 34.699 31.3074 34.7257C30.9315 34.7487 30.6602 34.9027 30.6183 34.8734C30.5977 34.8606 30.6398 34.8001 30.7578 34.7309C30.8738 34.6619 31.0738 34.5888 31.308 34.5732C31.5423 34.558 31.7416 34.6045 31.857 34.6583C31.975 34.712 32.0162 34.7667 31.9954 34.7823Z" fill="#0C2B34"/>
                    <path d="M28.8605 34.5281C28.8076 34.54 28.6185 34.3172 28.271 34.1752C27.9255 34.0296 27.616 34.0452 27.5914 34.001C27.5786 33.9806 27.6426 33.9461 27.7782 33.9374C27.912 33.9281 28.122 33.952 28.338 34.0418C28.5541 34.1316 28.7115 34.26 28.7909 34.358C28.8727 34.4571 28.8859 34.5235 28.8605 34.5281Z" fill="#0C2B34"/>
                    <path d="M28.6698 35.0109C28.6514 35.1282 28.5369 35.2094 28.4141 35.1924C28.2915 35.1755 28.2067 35.0669 28.2252 34.9495C28.2436 34.8324 28.3579 34.7511 28.4807 34.768C28.6034 34.7849 28.6882 34.8938 28.6698 35.0109Z" fill="#0C2B34"/>
                    <path d="M31.6969 35.5481C31.6785 35.6652 31.564 35.7464 31.4414 35.7294C31.3189 35.7125 31.2341 35.6039 31.2525 35.4865C31.2707 35.3694 31.3853 35.2883 31.508 35.3052C31.6308 35.3221 31.7154 35.4308 31.6969 35.5481Z" fill="#0C2B34"/>
                    <path d="M29.4922 36.7183C29.4942 36.7005 29.6915 36.7044 30.0086 36.7248C30.0889 36.7318 30.1659 36.7307 30.1895 36.6795C30.219 36.6266 30.2025 36.5355 30.1822 36.437C30.1451 36.2327 30.1065 36.0188 30.0657 35.7945C29.9078 34.8816 29.8097 34.137 29.8466 34.1309C29.8835 34.1248 30.0412 34.8601 30.1991 35.773C30.2359 35.9978 30.2715 36.2121 30.3051 36.417C30.3175 36.5118 30.349 36.6231 30.2863 36.7328C30.2537 36.7873 30.188 36.8187 30.1351 36.8226C30.0817 36.8283 30.0375 36.8205 29.9982 36.8153C29.6835 36.7719 29.49 36.7361 29.4922 36.7183Z" fill="#0C2B34"/>
                    <path d="M28.9452 32.9483C28.9038 33.0192 28.6398 32.931 28.3144 32.9093C27.9893 32.8804 27.7143 32.9273 27.6852 32.8507C27.6729 32.8145 27.7314 32.7514 27.8492 32.6976C27.9663 32.644 28.1437 32.6056 28.339 32.6206C28.5337 32.6358 28.7025 32.7008 28.8092 32.772C28.9166 32.8431 28.9636 32.9145 28.9452 32.9483Z" fill="#0C2B34"/>
                    <path d="M32.0908 33.9922C32.0483 34.0491 31.7928 33.9502 31.4748 33.9022C31.1572 33.8489 30.8868 33.8641 30.8607 33.7964C30.8495 33.7641 30.9087 33.7157 31.0256 33.6803C31.1416 33.6448 31.3167 33.6281 31.5071 33.6582C31.6975 33.6888 31.8609 33.7595 31.963 33.8296C32.0658 33.9001 32.1101 33.9649 32.0908 33.9922Z" fill="#0C2B34"/>
                    <path d="M25.3674 34.6449C25.3362 34.6235 24.0721 33.973 23.8513 35.3484C23.6309 36.7239 25.0572 36.6617 25.0659 36.6224C25.0748 36.5836 25.3674 34.6449 25.3674 34.6449Z" fill="#FCCBB6"/>
                    <path d="M24.7609 35.9963C24.7557 35.9909 24.7343 36.0091 24.6909 36.0212C24.6486 36.0329 24.5785 36.0345 24.5111 35.9963C24.3744 35.9195 24.2892 35.6692 24.3222 35.4202C24.3389 35.2944 24.384 35.1794 24.4443 35.0879C24.5024 34.994 24.5787 34.9341 24.654 34.9328C24.7295 34.9276 24.7742 34.9799 24.7848 35.0211C24.7972 35.0625 24.7839 35.0886 24.7909 35.0922C24.7943 35.0964 24.8241 35.074 24.8221 35.0152C24.8208 34.987 24.81 34.9521 24.7818 34.9205C24.7531 34.8884 24.7067 34.8669 24.6551 34.8643C24.5477 34.8545 24.4367 34.9367 24.3705 35.0374C24.2983 35.1376 24.2445 35.2662 24.2258 35.4074C24.1903 35.6859 24.2905 35.9681 24.4803 36.0575C24.5729 36.0982 24.6583 36.082 24.7052 36.0562C24.7531 36.029 24.7653 35.9995 24.7609 35.9963Z" fill="#F8A891"/>
                    <path d="M29.0971 37.597C29.1164 37.5638 28.8549 37.4506 28.695 37.174C28.6147 37.0376 28.5759 36.8949 28.5466 36.7904C28.5182 36.6852 28.495 36.6186 28.4796 36.6214C28.4651 36.6242 28.4603 36.6925 28.4696 36.8045C28.4798 36.9151 28.5085 37.0749 28.5996 37.2298C28.6885 37.3857 28.8208 37.4883 28.9204 37.5419C29.0208 37.5972 29.0922 37.6083 29.0971 37.597Z" fill="#0C2B34"/>
                    <path d="M35.383 32.3277C35.3708 32.244 35.3196 32.1703 35.2524 32.1188C35.1058 32.0069 34.9225 31.9978 34.7472 31.9742C34.2132 31.9022 33.7018 31.6759 33.2862 31.3337C33.1116 31.0051 32.9081 30.6914 32.6823 30.3954C32.1461 29.693 31.6943 29.2048 31.1994 28.9339C30.5589 28.5834 29.4472 28.3402 28.7243 28.4411C28.0012 28.5419 27.304 29.036 27.1214 29.7429C26.7674 29.3638 26.1768 29.2965 25.6751 29.4323L25.6636 29.4256C25.1077 29.5525 24.7379 30.08 24.516 30.6053C24.2941 31.1306 24.1579 31.7044 23.8121 32.1577C23.7399 32.2525 23.6538 32.3661 23.6937 32.4785C23.7247 32.5652 23.8249 32.6114 23.9171 32.609C24.0093 32.6064 24.0956 32.5659 24.1787 32.526C24.1024 32.6613 24.026 32.7969 23.9494 32.9322C24.1386 32.9886 24.3403 32.9969 24.5344 32.9622C24.5874 33.4845 24.6535 34.0814 24.7437 34.4416C24.9667 34.4675 25.1689 34.5076 25.2916 34.6475C25.4586 34.8375 25.5046 35.1635 25.8293 35.0804C25.9946 35.0379 26.1781 34.7236 26.2499 34.569C26.7275 33.5424 26.9798 32.4121 26.9856 31.2801C27.2344 31.0708 27.5238 30.9101 27.8328 30.8092L27.8066 30.8279C28.3929 30.699 29.0529 30.5821 29.5559 30.9101C29.9459 31.1643 30.1387 31.6232 30.4079 32.0032C30.918 32.7234 31.6683 33.1708 32.5396 33.3125C32.5021 33.8833 32.3591 34.6798 32.3216 35.2507L32.9068 34.3983L32.9066 34.403C32.9537 34.341 32.994 34.2777 33.0331 34.2143L33.0463 34.1952L33.0465 34.1926C33.109 34.0907 33.169 33.9879 33.2445 33.8885L33.2493 33.8942C33.5245 34.202 34.0269 33.8408 33.8237 33.4816C33.7833 33.4103 33.7326 33.345 33.6727 33.2888C33.7974 33.4376 33.9996 33.5257 34.1904 33.4907C34.3815 33.456 34.5466 33.2866 34.5533 33.0925C34.5579 32.9602 34.478 32.8318 34.3659 32.7659C34.6119 32.8145 34.8724 32.7904 35.1034 32.6928C35.255 32.6286 35.4101 32.5119 35.383 32.3277Z" fill="#0C2B34"/>
                    <path d="M27.7114 30.0781C27.7146 30.0838 27.6205 30.1213 27.4873 30.2391C27.355 30.3562 27.1971 30.5688 27.0984 30.8715C27.0483 31.0221 27.008 31.1921 26.9861 31.3778C26.9633 31.5635 26.9546 31.7641 26.944 31.9751C26.9327 32.1862 26.9214 32.4094 26.8806 32.638C26.8605 32.7521 26.8327 32.8675 26.7939 32.9813C26.7548 33.0933 26.7099 33.2143 26.6117 33.3028C26.5329 33.375 26.4132 33.3971 26.3156 33.3648C26.2171 33.3349 26.1338 33.2707 26.0768 33.1898C25.9651 33.023 25.9556 32.8271 25.9434 32.654L25.9851 32.6642C25.8979 32.8083 25.8091 32.9499 25.6899 33.0575C25.5721 33.1659 25.4194 33.2288 25.2721 33.2245C25.199 33.2225 25.1272 33.2021 25.0686 33.1635C25.0088 33.1251 24.9689 33.067 24.9439 33.0078C24.9205 32.9475 24.9123 32.8835 24.9222 32.8239C24.9329 32.7644 24.9628 32.7104 25.0057 32.6746L25.0248 32.6963C24.8483 32.8549 24.673 32.9308 24.5533 32.9698C24.4928 32.9896 24.4451 32.9998 24.4127 33.0061C24.3804 33.0117 24.3635 33.0137 24.3633 33.0124C24.3631 33.0111 24.3796 33.0065 24.4112 32.9985C24.4427 32.9896 24.4893 32.977 24.5481 32.9553C24.665 32.9119 24.8355 32.8332 25.0053 32.6751L25.0244 32.6968C24.948 32.7605 24.9292 32.8863 24.9756 32.9948C24.9988 33.0481 25.0357 33.1002 25.0886 33.133C25.1409 33.1668 25.2064 33.1848 25.2734 33.1859C25.4085 33.1887 25.5508 33.1295 25.6614 33.0262C25.7742 32.9234 25.8603 32.7853 25.9467 32.641L25.9833 32.5796L25.9883 32.6512C26.0005 32.8239 26.013 33.0124 26.1152 33.1629C26.1662 33.2353 26.2425 33.2935 26.3288 33.3193C26.4152 33.3468 26.5119 33.3288 26.5804 33.267C26.6663 33.1904 26.7112 33.0763 26.7492 32.9662C26.7872 32.8549 26.8147 32.7421 26.8349 32.6297C26.8756 32.405 26.8878 32.1836 26.9004 31.973C26.9121 31.7619 26.9223 31.5606 26.947 31.3728C26.9711 31.185 27.0138 31.013 27.0667 30.8607C27.1709 30.5544 27.3368 30.3399 27.4749 30.2252C27.6146 30.1098 27.7114 30.0781 27.7114 30.0781Z" fill="#335863"/>
                    <path d="M33.7441 32.756L33.7263 32.768C33.7113 32.7762 33.6933 32.7864 33.6714 32.7988C33.6476 32.8126 33.6172 32.8285 33.5795 32.8432C33.5424 32.8591 33.4999 32.8786 33.4493 32.8933C33.2515 32.9601 32.9407 33.0128 32.5681 32.9462C32.1987 32.8812 31.7679 32.6964 31.4046 32.3526C31.0363 32.0153 30.7333 31.5468 30.5023 31.0241C30.3845 30.7625 30.2947 30.4981 30.1904 30.2513C30.0869 30.0044 29.9679 29.7736 29.8128 29.5841C29.6599 29.3938 29.474 29.2448 29.2738 29.1626C29.1742 29.1197 29.071 29.1004 28.9716 29.0911C28.8714 29.0845 28.7749 29.0934 28.6847 29.1117C28.504 29.1494 28.3524 29.2288 28.2344 29.3149C28.1157 29.4019 28.0318 29.4986 27.9719 29.583C27.8583 29.7574 27.839 29.8758 27.832 29.873L27.8362 29.8519C27.8407 29.8357 27.8463 29.8157 27.8529 29.7914C27.8693 29.7385 27.9017 29.663 27.9565 29.5728C28.0149 29.4854 28.0988 29.3845 28.2185 29.2936C28.3376 29.2034 28.4918 29.1199 28.6775 29.0789C28.7701 29.059 28.8701 29.0488 28.974 29.0544C29.077 29.0631 29.1853 29.0826 29.2885 29.1262C29.4967 29.2097 29.6894 29.3626 29.8466 29.5565C30.0065 29.7498 30.1286 29.9849 30.2333 30.2333C30.339 30.4818 30.429 30.7456 30.5457 31.0048C30.7749 31.5234 31.0734 31.9867 31.4343 32.3205C31.7907 32.6608 32.2108 32.8445 32.5741 32.9131C32.94 32.9829 33.2465 32.9363 33.4437 32.8758C33.6424 32.8139 33.7411 32.75 33.7441 32.756Z" fill="#335863"/>
                    <path d="M34.0315 31.9237C34.0328 31.9268 34.0051 31.9415 33.9532 31.9656C33.9018 31.9905 33.8242 32.0196 33.7261 32.0489C33.6283 32.0788 33.5086 32.1036 33.3741 32.12C33.2394 32.1341 33.0899 32.1387 32.9338 32.1261C32.7778 32.1118 32.6314 32.0816 32.5009 32.0448C32.3714 32.0053 32.2575 31.9606 32.1662 31.9144C32.0746 31.8689 32.0033 31.8268 31.9569 31.7934C31.91 31.7608 31.8851 31.7415 31.8868 31.7387C31.8918 31.7313 31.9963 31.8018 32.1803 31.8838C32.272 31.9257 32.385 31.9665 32.513 32.0027C32.6414 32.0367 32.7852 32.0647 32.9379 32.0788C33.0908 32.091 33.2372 32.0879 33.3695 32.0767C33.5016 32.0628 33.6201 32.042 33.7174 32.0166C33.9129 31.9671 34.028 31.9155 34.0315 31.9237Z" fill="#335863"/>
                    <path d="M30.5654 51.2453C29.0007 51.2453 25.9977 50.6362 25.9977 50.6362L25.6721 51.2216L24.9882 51.2214C24.98 51.2216 24.9722 51.2216 24.9639 51.2216C23.0116 51.2216 20.3125 47.3146 20.3125 47.3146L24.9002 49.771L25.9326 49.1695L31.2981 51.1615C31.1359 51.2205 30.8797 51.2453 30.5654 51.2453Z" fill="#CC5749"/>
                    <path d="M23.6836 49.1347C23.6836 49.1347 33.4431 51.9787 34.5922 51.7143C35.7416 51.4501 42.8724 45.7352 42.8724 45.7352L41.263 43.7989L33.8983 47.8703L25.0624 45.0665L23.6836 49.1347Z" fill="#FCCBB6"/>
                    <path d="M21.2173 41.9433C21.2173 41.9433 19.5858 42.3038 19.3454 44.9836C19.0585 48.1829 25.377 50.6847 25.377 50.6847L28.4984 45.4632L21.2173 41.9433Z" fill="#DE5757"/>
                    <path d="M24.5854 43.9946C24.5867 43.9923 24.6104 44.0011 24.6555 44.0205C24.7082 44.0441 24.7733 44.0732 24.8533 44.1092C25.0355 44.1944 25.2851 44.3115 25.5979 44.4579C26.2473 44.7701 27.1572 45.2071 28.2465 45.7303L28.2933 45.7526L28.2671 45.7982C27.6509 46.8655 26.9219 48.1275 26.1428 49.4764C25.9063 49.8839 25.6743 50.2835 25.4519 50.6661L25.4289 50.7058L25.3856 50.6908C24.4548 50.3665 23.6007 49.992 22.8812 49.5618C22.1594 49.1354 21.5766 48.6617 21.1282 48.2316C20.235 47.3638 19.8242 46.7306 19.8242 46.7306C19.8268 46.7287 19.8587 46.7629 19.9173 46.8306C19.9819 46.9065 20.0661 47.0057 20.1715 47.1295C20.3962 47.3861 20.7254 47.7583 21.1786 48.178C21.6306 48.5981 22.2127 49.0606 22.9309 49.4775C23.6469 49.8978 24.4954 50.265 25.422 50.5854L25.3556 50.6101C25.5773 50.2273 25.809 49.8275 26.0452 49.4198C26.8293 48.0737 27.5628 46.8146 28.1834 45.7496L28.204 45.8173C27.1219 45.2791 26.2182 44.8297 25.573 44.5089C25.2652 44.3521 25.0197 44.2269 24.8403 44.1358C24.7628 44.0946 24.6997 44.0612 24.649 44.0341C24.6058 44.0103 24.5843 43.997 24.5854 43.9946Z" fill="#0C2B34"/>
                    <path d="M32.1913 44.8218C32.1603 44.8337 31.8913 44.1767 31.4963 43.3976C31.104 42.617 30.7352 42.0105 30.7632 41.9925C30.7758 41.9845 30.8845 42.1261 31.0409 42.3682C31.197 42.6102 31.3987 42.954 31.5974 43.3466C31.7952 43.7394 31.9521 44.1058 32.054 44.3754C32.1557 44.6448 32.2052 44.8163 32.1913 44.8218Z" fill="#0C2B34"/>
                    <path d="M8.69154 92.1392C8.68981 92.1379 8.70477 92.1153 8.73514 92.0728C8.76919 92.0257 8.81452 91.9637 8.87222 91.885C8.99867 91.716 9.17848 91.4759 9.40797 91.1692C9.88124 90.5454 10.5591 89.652 11.3952 88.5501C13.0851 86.3405 15.4135 83.2968 17.9851 79.9348C18.2849 79.5442 18.5811 79.1583 18.8599 78.795L18.8512 78.8117C20.0812 75.1079 21.1764 71.8114 21.9661 69.4335C22.3635 68.2538 22.6836 67.3023 22.907 66.6388C23.0183 66.3158 23.1051 66.0633 23.1664 65.8853C23.1957 65.8039 23.2187 65.7395 23.2363 65.6905C23.2526 65.6469 23.2619 65.625 23.2636 65.6252C23.2651 65.6258 23.2595 65.649 23.2467 65.6939C23.2315 65.7436 23.2118 65.8091 23.1868 65.8918C23.13 66.0716 23.0495 66.3262 22.9465 66.6518C22.7311 67.3179 22.4218 68.2731 22.0386 69.4574C21.2575 71.8383 20.1745 75.1387 18.9579 78.847L18.9549 78.8562L18.9492 78.8637C18.6705 79.2268 18.3742 79.6131 18.0747 80.0036C15.4929 83.3575 13.1554 86.3943 11.4585 88.5987C10.6105 89.6914 9.92289 90.5775 9.44289 91.1961C9.20603 91.4972 9.0208 91.7329 8.89022 91.8986C8.82906 91.9748 8.78069 92.0344 8.74425 92.0797C8.71085 92.1203 8.69306 92.1405 8.69154 92.1392Z" fill="#335863"/>
                    <path d="M28.6088 75.3949C28.6192 75.4242 28.1912 75.6019 27.6533 75.7914C27.1152 75.9812 26.6708 76.1109 26.6603 76.0817C26.6499 76.0522 27.0777 75.8745 27.6158 75.6847C28.1537 75.4951 28.5981 75.3654 28.6088 75.3949Z" fill="#335863"/>
                    <path d="M28.5607 76.7949C28.5522 76.8251 28.174 76.7441 27.7161 76.6142C27.2582 76.4841 26.894 76.3548 26.9025 76.3247C26.9109 76.2945 27.289 76.3754 27.7469 76.5056C28.2048 76.6353 28.5691 76.7648 28.5607 76.7949Z" fill="#335863"/>
                    <path d="M28.7215 57.6179C28.7254 57.6244 28.6369 57.6858 28.4733 57.7908C28.3104 57.8975 28.0669 58.0392 27.7595 58.2025C27.1455 58.53 26.2599 58.92 25.2365 59.2126C24.2119 59.5028 23.2536 59.6373 22.5591 59.6822C22.2118 59.7049 21.9301 59.7128 21.7355 59.7078C21.541 59.7045 21.4336 59.6991 21.4336 59.6913C21.4336 59.6835 21.541 59.6742 21.7344 59.6637C21.9281 59.6553 22.2079 59.6355 22.5526 59.6024C23.2415 59.5377 24.1893 59.3917 25.2055 59.1039C26.2206 58.8137 27.1034 58.4389 27.7233 58.1313C28.0335 57.978 28.2818 57.8476 28.451 57.7528C28.621 57.6596 28.7173 57.6112 28.7215 57.6179Z" fill="#0C2B34"/>
                    <path d="M60.8879 92.0125L62.3388 95.5514C62.3388 95.5514 58.2979 97.0606 58.2539 97.8079L66.0721 97.7886L64.7926 91.9923L60.8879 92.0125Z" fill="#335863"/>
                    <path d="M64.663 95.8224C64.6417 95.8224 64.6205 95.82 64.5996 95.8148C64.4476 95.7765 64.3151 95.5765 64.3669 95.4283C64.4075 95.3116 64.5454 95.2149 64.6699 95.2149C64.7033 95.2149 64.7356 95.2218 64.7649 95.2375C64.9009 95.2906 64.9907 95.4487 64.9582 95.5919C64.9283 95.7237 64.7964 95.8224 64.663 95.8224Z" fill="#A6B6BB"/>
                    <path d="M58.2596 97.8024H58.2544C58.2436 97.6362 58.4082 97.5159 58.5021 97.461C58.3637 97.5844 58.2765 97.7 58.2596 97.8024Z" fill="white"/>
                    <path d="M58.2565 97.826C58.2552 97.8182 58.2543 97.8104 58.2539 97.8028H58.2591C58.2578 97.8106 58.2569 97.8182 58.2565 97.826L66.0747 97.8067V97.8069L58.2565 97.826Z" fill="#9DA7AA"/>
                    <path d="M58.2539 97.8169C58.2543 97.8091 58.2552 97.8015 58.2565 97.7937C58.2734 97.6913 58.3606 97.5757 58.499 97.4522C58.5359 97.4308 58.5617 97.4195 58.5617 97.4195L65.9333 97.1681L66.0721 97.7976L58.2539 97.8169Z" fill="#A6B6BB"/>
                    <path d="M62.2073 95.5434C62.2086 95.5816 62.3996 95.5985 62.5877 95.7206C62.779 95.8382 62.8762 96.0032 62.9113 95.988C62.9467 95.9804 62.889 95.7525 62.6586 95.6085C62.4296 95.4623 62.1988 95.5085 62.2073 95.5434Z" fill="#0C2B34"/>
                    <path d="M61.3792 95.8653C61.3708 95.9024 61.5362 95.9668 61.6662 96.128C61.8009 96.2855 61.8343 96.4599 61.872 96.4579C61.908 96.464 61.934 96.2401 61.7683 96.043C61.6046 95.8443 61.3801 95.8289 61.3792 95.8653Z" fill="#0C2B34"/>
                    <path d="M60.9517 96.8497C60.9864 96.8577 61.0391 96.6668 60.9404 96.4582C60.8434 96.2484 60.6632 96.1664 60.6471 96.1981C60.6257 96.2298 60.7417 96.3415 60.8202 96.5144C60.9024 96.6851 60.9137 96.846 60.9517 96.8497Z" fill="#0C2B34"/>
                    <path d="M61.9154 94.8162C61.9315 94.8509 62.1063 94.7977 62.3223 94.8118C62.5384 94.8216 62.7062 94.8936 62.7262 94.8608C62.7481 94.8331 62.5839 94.6921 62.3295 94.6791C62.0753 94.6639 61.8966 94.786 61.9154 94.8162Z" fill="#0C2B34"/>
                    <path d="M61.8164 94.3337C61.8162 94.3496 61.9672 94.3728 62.2081 94.3309C62.3281 94.3097 62.4693 94.27 62.6176 94.204C62.6916 94.1706 62.7671 94.1309 62.8421 94.0841C62.8781 94.0607 62.9206 94.0372 62.9601 93.9915C63.0022 93.9518 63.0263 93.8505 62.977 93.7887C62.9367 93.7284 62.866 93.7028 62.8098 93.7015C62.7519 93.6997 62.7053 93.7117 62.6627 93.7223C62.5758 93.7438 62.4942 93.7726 62.4196 93.8064C62.2704 93.8748 62.1494 93.9611 62.0591 94.0442C61.8782 94.2127 61.8164 94.3554 61.8296 94.3628C61.847 94.3754 61.9348 94.2557 62.1192 94.1164C62.2112 94.0472 62.3285 93.9756 62.4678 93.9188C62.5378 93.8908 62.6129 93.8667 62.6925 93.849C62.7753 93.827 62.8458 93.8262 62.8671 93.8631C62.8747 93.8772 62.8757 93.8826 62.8586 93.9069C62.8406 93.9292 62.8072 93.9513 62.7718 93.9743C62.7027 94.0197 62.6332 94.0591 62.5654 94.0932C62.4291 94.1611 62.2988 94.2075 62.1871 94.2392C61.9633 94.3023 61.8158 94.3131 61.8164 94.3337Z" fill="#0C2B34"/>
                    <path d="M61.8438 94.3568C61.8574 94.3627 61.9325 94.2258 61.9461 93.9783C61.9522 93.8558 61.9392 93.7072 61.8917 93.55C61.8674 93.4714 61.8344 93.3912 61.7913 93.3125C61.7453 93.2352 61.6891 93.132 61.5412 93.1153C61.4635 93.1127 61.3996 93.173 61.3779 93.2248C61.3521 93.2778 61.3471 93.3233 61.338 93.3686C61.3239 93.46 61.3258 93.5495 61.3382 93.6322C61.3633 93.7985 61.4319 93.9369 61.5067 94.0365C61.6598 94.2384 61.8192 94.2837 61.8225 94.2709C61.8351 94.2516 61.7019 94.1783 61.5846 93.984C61.5264 93.8879 61.475 93.7614 61.4599 93.6161C61.4518 93.5439 61.4529 93.4671 61.4664 93.3899C61.4785 93.3068 61.5093 93.2398 61.5405 93.2483C61.5796 93.2474 61.6455 93.3099 61.6778 93.376C61.718 93.4461 61.7503 93.5176 61.7754 93.5879C61.8245 93.7293 61.8464 93.8645 61.852 93.9786C61.8633 94.208 61.8229 94.351 61.8438 94.3568Z" fill="#0C2B34"/>
                    <path d="M66.0073 62.6968C65.787 62.8087 57.7593 74.0388 55.4449 77.1314C55.0207 77.6984 54.8213 78.4267 54.9979 79.1126C56.0247 83.105 60.2339 95.3691 60.2339 95.3691L65.8709 94.1989L62.3302 79.5405L71.0796 70.155L70.0918 62.6953L66.0073 62.6968Z" fill="#0C2B34"/>
                    <path d="M62.2464 79.7658C62.2307 79.7929 61.9034 79.6342 61.5154 79.4112C61.1272 79.1878 60.825 78.9852 60.8404 78.9581C60.856 78.931 61.1831 79.09 61.5714 79.3129C61.9598 79.5361 62.2618 79.7389 62.2464 79.7658Z" fill="#335863"/>
                    <path d="M42.7696 36.5235C42.808 36.5456 43.1353 36.7083 43.4418 36.8599C43.8001 37.0373 44.0979 37.3163 44.2977 37.6627C44.5293 38.0637 44.8124 38.5487 44.8371 38.5674C44.8794 38.5992 45.9967 39.4684 45.9967 39.4684L44.4191 41.6352L43.9856 41.2849C43.9856 41.2849 42.4091 41.2012 41.8159 40.9129C41.2227 40.6244 40.6726 40.1557 40.7422 39.9492C40.8119 39.7423 40.8333 39.6788 40.8333 39.6788C40.8333 39.6788 40.5852 39.312 40.6817 38.9727C40.6817 38.9727 40.321 38.5559 40.387 38.2591C40.4932 37.7807 40.9427 37.7169 40.9427 37.7169C40.9427 37.7169 40.7668 37.2317 40.9427 36.9723C41.1186 36.7131 41.4741 36.638 41.4741 36.638L42.9492 37.2746L42.7696 36.5235Z" fill="#D88875"/>
                    <path d="M82.9102 92.6326L85.4895 95.7286C85.4895 95.7286 83.2093 99.3904 83.6303 100.009L89.8124 95.2228L85.991 90.2343L82.9102 92.6326Z" fill="#335863"/>
                    <path d="M87.3323 94.5368C87.2037 94.5368 87.0625 94.4646 87.025 94.3511C86.9755 94.2023 87.0694 93.9833 87.2237 93.9568C87.2506 93.949 87.2783 93.9453 87.3063 93.9453C87.4241 93.9453 87.5434 94.0119 87.5933 94.1197C87.6592 94.262 87.5889 94.4526 87.4449 94.5149C87.4108 94.5299 87.3722 94.5368 87.3323 94.5368Z" fill="#A6B6BB"/>
                    <path d="M83.6232 99.9911C83.4913 99.8675 83.552 99.6577 83.5948 99.5525C83.5579 99.7488 83.5625 99.9018 83.6232 99.9911L86.3238 97.9004L83.6232 99.9911Z" fill="white"/>
                    <path d="M83.5948 100C83.5341 99.9109 83.5295 99.758 83.5664 99.5617C83.5825 99.5225 83.5961 99.4977 83.5961 99.4977L89.3722 94.7266L89.7769 95.2144L86.2955 97.9096L83.5948 100Z" fill="#A6B6BB"/>
                    <path d="M85.3548 95.7354C85.3793 95.7647 85.5409 95.6615 85.7645 95.6437C85.9875 95.6198 86.1656 95.6914 86.1838 95.6578C86.2072 95.6304 86.0224 95.4847 85.752 95.5111C85.4815 95.5352 85.3268 95.7127 85.3548 95.7354Z" fill="#0C2B34"/>
                    <path d="M84.9119 96.4985C84.9275 96.5332 85.098 96.4831 85.2995 96.5317C85.5023 96.574 85.635 96.692 85.6641 96.6675C85.696 96.6501 85.5802 96.4571 85.3285 96.4018C85.0776 96.3445 84.8902 96.4692 84.9119 96.4985Z" fill="#0C2B34"/>
                    <path d="M85.1585 97.5871C85.191 97.5726 85.1162 97.3891 84.9108 97.2839C84.7058 97.1767 84.513 97.2218 84.5197 97.257C84.5219 97.2949 84.6822 97.3127 84.8494 97.4019C85.019 97.4869 85.1262 97.6075 85.1585 97.5871Z" fill="#0C2B34"/>
                    <path d="M84.8245 94.9647C84.8584 94.9822 84.9646 94.8334 85.1442 94.7131C85.3214 94.589 85.4984 94.5435 85.4941 94.5053C85.4947 94.4699 85.2785 94.4584 85.0692 94.6033C84.8586 94.7467 84.7911 94.9523 84.8245 94.9647Z" fill="#0C2B34"/>
                    <path d="M84.541 94.6785L84.082 94.1261L84.1271 94.0918L84.5863 94.6427L84.541 94.6785Z" fill="#A8ABAB"/>
                    <path d="M84.5881 94.6067L84.1289 94.0558L87.1677 91.7482L87.5596 92.2627L84.5881 94.6067Z" fill="#193A42"/>
                    <path d="M84.3267 94.3622C84.3362 94.375 84.4699 94.3013 84.6351 94.121C84.7174 94.031 84.8052 93.9135 84.882 93.7707C84.9204 93.6992 84.9559 93.6215 84.987 93.5387C85.0011 93.4983 85.0206 93.4539 85.0241 93.3933C85.0332 93.3361 84.9902 93.2413 84.9134 93.2222C84.8451 93.1992 84.7733 93.222 84.728 93.2556C84.6811 93.2894 84.6512 93.3272 84.6241 93.3615C84.5681 93.4315 84.5213 93.5042 84.4829 93.5766C84.4061 93.7217 84.3629 93.864 84.3423 93.985C84.3018 94.2288 84.3399 94.3794 84.3549 94.3772C84.3762 94.3768 84.3729 94.2282 84.4339 94.0056C84.4647 93.8948 84.5137 93.7662 84.5896 93.636C84.628 93.5714 84.6729 93.5063 84.7249 93.4439C84.7772 93.3758 84.8325 93.3322 84.872 93.3482C84.8865 93.3549 84.8909 93.3586 84.8917 93.3883C84.8913 93.417 84.8783 93.4549 84.8642 93.4946C84.8371 93.5727 84.8063 93.6462 84.7731 93.7148C84.7067 93.8519 84.6319 93.9681 84.5627 94.0612C84.4237 94.2479 84.3135 94.3464 84.3267 94.3622Z" fill="#0C2B34"/>
                    <path d="M84.4127 94.3466C84.427 94.3427 84.4032 94.1883 84.2628 93.9842C84.193 93.8833 84.0919 93.7736 83.9581 93.6779C83.8913 93.6307 83.8162 93.5871 83.7338 93.5511C83.6503 93.5179 83.5427 93.4706 83.4154 93.5476C83.3523 93.5927 83.3386 93.6797 83.3527 93.7339C83.3649 93.7916 83.3885 93.8308 83.4089 93.8721C83.4536 93.9532 83.5098 94.023 83.5701 94.0809C83.6915 94.1974 83.8301 94.2653 83.9501 94.2983C84.1949 94.3651 84.3487 94.3035 84.3435 94.2913C84.3418 94.2683 84.1913 94.2915 83.9798 94.2091C83.8755 94.1686 83.7572 94.0998 83.6566 93.9942C83.6061 93.9417 83.5601 93.8801 83.5236 93.8109C83.4826 93.7376 83.4664 93.6656 83.4959 93.653C83.5262 93.6289 83.6169 93.638 83.6828 93.6706C83.7575 93.7016 83.8266 93.7387 83.8896 93.779C84.0147 93.8608 84.1143 93.9547 84.1887 94.0417C84.3375 94.2165 84.3928 94.3547 84.4127 94.3466Z" fill="#0C2B34"/>
                    <path d="M77.345 62.4512C77.4664 62.7889 78.9006 80.1247 78.9006 80.1247L88.5676 92.9343L84.4589 95.7991L73.5338 84.5803C73.0093 84.0491 72.6489 83.378 72.4953 82.6475L68.457 63.4413L77.345 62.4512Z" fill="#0C2B34"/>
                    <path d="M54.483 44.277L62.9925 44.4616L63.5781 44.554L61.2172 49.7672L52.5288 48.5176L43.9961 42.2056L46.2757 39.0137L54.483 44.277Z" fill="#DE5757"/>
                    <path d="M68.0731 44.0431L71.3394 44.8894C72.1714 45.1376 72.8368 45.7646 73.1338 46.5806L74.0517 49.8981L75.9739 57.2916L77.8499 63.9973C74.5092 65.5239 71.8619 67.6057 67.669 67.7369C67.0829 67.7552 66.4992 67.648 65.9598 67.4183L63.2184 66.2523L64.1118 62.0407L60.8398 49.5398L63.3372 44.5806L64.1905 44.466L68.0731 44.0431Z" fill="#DE5757"/>
                    <path d="M55.8387 39.9556C55.8162 39.8281 55.8444 39.6949 55.9101 39.5832C56.0656 39.319 56.3524 39.1956 56.6263 39.0819C56.6641 38.6889 56.6365 38.29 56.545 37.9059C56.4157 37.9605 56.2691 37.9701 56.1307 37.9434C56.1084 37.9458 56.0862 37.9499 56.0624 37.9484C55.7494 37.9289 55.5698 37.5419 55.6451 37.2374C55.7203 36.9331 55.9617 36.7023 56.1921 36.4897C55.9966 36.5791 55.8765 36.7776 55.708 36.9112C55.5392 37.0448 55.2438 37.083 55.1442 36.8921C55.1139 36.834 55.1091 36.7663 55.1054 36.7006C55.0974 36.5683 55.0894 36.436 55.0811 36.3034C55.0748 36.1967 55.072 36.0776 55.1421 35.9965C55.1909 35.9395 55.2663 35.9134 55.3271 35.869C55.5281 35.7221 55.5392 35.4052 55.7385 35.2564C55.8852 35.1467 56.086 35.1623 56.2673 35.1374C56.4491 35.1126 56.6567 34.9951 56.6454 34.8122C56.3803 34.7652 56.104 34.7133 55.8899 34.5504C55.6756 34.3873 55.5481 34.0763 55.678 33.8405C55.78 33.6561 55.9973 33.5748 56.1971 33.508C56.4196 33.4332 56.7113 33.3779 56.8512 33.567C57.1163 33.3594 57.5596 33.4497 57.723 33.7444C57.9039 33.6529 58.0845 33.5611 58.2654 33.4696C58.0425 33.3609 57.7787 33.344 57.5703 33.2091C57.362 33.0742 57.2573 32.7274 57.4651 32.5916C57.5408 32.5419 57.6412 32.5339 57.708 32.4723C57.7559 32.4278 57.783 32.3586 57.8433 32.3328C57.8872 32.3142 57.937 32.3237 57.9837 32.3337C58.481 32.4395 58.9782 32.5456 59.4755 32.6517C59.2719 32.4432 59.0682 32.235 58.8645 32.0266C58.6767 31.8344 58.4771 31.5468 58.6283 31.3247C58.7747 31.1097 59.1428 31.1963 59.2768 31.419C59.4723 31.2717 59.7983 31.3654 59.8857 31.5938C60.0189 31.4696 60.2364 31.4472 60.3921 31.542C60.5479 31.6366 60.6279 31.8402 60.5785 32.0157C60.7797 31.9424 61.0008 31.9253 61.2109 31.9663C61.1068 31.7121 61.4213 31.4064 61.6723 31.5179C61.6326 31.3969 61.5925 31.2665 61.6289 31.1442C61.6651 31.0221 61.8135 30.9262 61.9228 30.9915C61.8259 30.8434 61.8341 30.6343 61.9423 30.4944C62.0508 30.3545 62.2514 30.2942 62.4189 30.3512C62.4538 30.2467 62.4889 30.1421 62.5236 30.0378C62.7227 29.9526 62.9778 29.9532 63.1318 30.1053C63.2856 30.2573 63.2492 30.5757 63.0412 30.6351C63.1815 30.5781 63.2364 30.8163 63.1982 30.9629C63.1448 31.167 63.0915 31.3713 63.0381 31.5754C63.1301 31.3856 63.3591 31.2579 63.5667 31.316C63.6361 31.1284 63.886 31.0342 64.0621 31.1292C64.0818 30.8883 64.4794 30.8071 64.5918 31.0214C64.5911 30.9156 64.7156 30.8612 64.818 30.834C64.9649 30.795 65.1249 30.7568 65.2644 30.8173C65.4034 30.8779 65.4826 31.0848 65.3685 31.1852C65.4631 31.0709 65.67 31.144 65.7253 31.2817C65.7806 31.4192 65.7294 31.5758 65.6622 31.7082C65.595 31.8405 65.5097 31.9695 65.4934 32.117C65.5663 31.9869 65.7188 31.9281 65.8596 31.8791C66.1103 31.7917 66.3741 31.7027 66.6365 31.7448C66.6409 31.6309 66.7751 31.5741 66.8875 31.5552C67.2375 31.4967 67.6048 31.5446 67.9279 31.6912C68.0806 31.7606 68.2433 31.8899 68.2214 32.0563C68.2116 32.132 68.1639 32.1966 68.1177 32.2576C67.9234 32.5137 67.7293 32.7699 67.5351 33.026C67.9999 32.9948 68.4737 33.115 68.8671 33.364C69.0543 33.3937 69.2521 33.3284 69.433 33.3852C69.6139 33.4423 69.7163 33.7379 69.5393 33.806C69.6822 33.8492 69.7859 33.9971 69.7783 34.1461C69.7753 34.211 69.7482 34.2717 69.7098 34.324C69.6998 34.3678 69.6851 34.411 69.6625 34.4511C69.62 34.5266 69.5632 34.5869 69.4985 34.6381C69.4599 34.7723 69.351 34.8888 69.2172 34.9278C69.4079 35.0007 69.594 35.0857 69.7475 35.2183C69.9473 35.3911 70.0826 35.6649 70.0171 35.9206L70.0015 35.9607C70.0152 36.0564 69.9944 36.1559 69.9371 36.2295C69.9876 36.2754 70.0245 36.3347 70.0362 36.4054C70.3251 36.403 70.6093 36.5709 70.7468 36.8251C70.8843 37.0793 70.8691 37.4092 70.7086 37.6495C70.5804 37.8417 70.2455 37.9447 70.1462 37.7363C70.131 37.9391 70.0074 38.1306 69.8289 38.2278C70.0902 38.4423 70.0924 38.8997 69.833 39.1169C70.247 39.2539 70.3629 39.8983 70.0228 40.1712C70.1902 40.3682 70.1629 40.6994 69.9657 40.8662C69.7686 41.033 69.4374 41.005 69.2708 40.8074C69.2482 41.0061 69.2204 41.2171 69.0929 41.3709C68.9652 41.5249 68.7001 41.5813 68.5693 41.4301C68.5917 41.8357 68.1496 42.1942 67.7575 42.0882C67.8418 42.2914 67.7436 42.5519 67.5462 42.6489C67.3486 42.7458 67.0822 42.6641 66.9736 42.473C66.6209 42.6051 66.2682 42.7372 65.9155 42.8692C65.6813 42.9571 65.4455 43.0452 65.1993 43.0881C64.8848 43.1428 64.5573 43.1213 64.2525 43.0261C64.1543 42.9953 64.0537 42.9564 63.9521 42.9718C63.8355 42.9894 63.7422 43.0738 63.6487 43.1458C63.1559 43.526 62.4577 43.6215 61.8807 43.3874C61.7899 43.3508 61.6994 43.3057 61.6014 43.2994C61.4884 43.2924 61.3797 43.3375 61.2736 43.3764C61.0134 43.4718 60.7407 43.5343 60.4648 43.5616C60.228 43.5852 59.9646 43.5742 59.7876 43.4154C59.6104 43.2564 59.6113 42.9055 59.8345 42.8233C59.797 42.6734 59.705 42.5287 59.5627 42.4682C59.4202 42.4079 59.228 42.4602 59.1669 42.6022C59.1061 42.7443 59.2413 42.9384 59.3916 42.9022C59.2165 43.1584 58.7574 43.0705 58.6396 42.7834C58.5218 42.496 58.7168 42.1446 59.0057 42.0309C58.868 41.8466 58.7771 41.6275 58.7435 41.3997C58.6687 41.6442 58.3761 41.7969 58.1329 41.7186C58.0828 41.95 57.9598 42.1771 57.7551 42.296C57.5499 42.4151 57.2571 42.3944 57.1078 42.2103C56.9588 42.0261 57.0365 41.6926 57.2657 41.6338C57.0152 41.4459 57.1026 40.9742 57.4037 40.8885C57.2486 40.6237 57.3059 40.2534 57.534 40.048C57.4041 40.22 57.1059 40.2198 56.9766 40.0478C56.9241 40.3111 56.5773 40.3855 56.312 40.3419C56.104 40.3079 55.8867 40.2287 55.8387 39.9556Z" fill="#0C2B34"/>
                    <path d="M55.8669 40.0019C55.8669 40.0019 55.8678 40.0336 55.8877 40.0926C55.9075 40.1501 55.9548 40.2392 56.0621 40.3043C56.1689 40.3678 56.3216 40.4095 56.5055 40.4097C56.5972 40.4077 56.6974 40.3941 56.7966 40.3507C56.8937 40.3086 56.9935 40.2229 57.018 40.0967L56.9939 40.1023C57.1087 40.262 57.4126 40.3023 57.5752 40.1041L57.5512 40.0822C57.3436 40.2646 57.2416 40.6359 57.4152 40.9446L57.4267 40.9162C57.2781 40.9571 57.1709 41.097 57.1395 41.2506C57.105 41.4018 57.1397 41.5901 57.2809 41.6976L57.2887 41.6588C57.1191 41.7022 57.0241 41.8887 57.0378 42.0605C57.0425 42.2425 57.2037 42.3969 57.3846 42.429C57.5648 42.4681 57.7696 42.4136 57.9106 42.28C58.0546 42.1492 58.1444 41.9646 58.1873 41.7705L58.1528 41.7903C58.3871 41.8692 58.7083 41.7341 58.7986 41.4545L58.7437 41.4502C58.7738 41.6616 58.8612 41.8955 59.0103 42.095L59.0231 42.0499C58.8829 42.1056 58.7639 42.2128 58.6871 42.3468C58.6103 42.48 58.576 42.6492 58.627 42.806C58.6756 42.9665 58.825 43.0813 58.9857 43.1173C59.1434 43.1563 59.3432 43.1186 59.4467 42.9667L59.4959 42.8945L59.4122 42.9168C59.3285 42.9392 59.2373 42.8576 59.2183 42.7641C59.1931 42.6698 59.264 42.5741 59.3619 42.5414C59.4605 42.5056 59.5749 42.5247 59.659 42.595C59.7442 42.6631 59.8015 42.7676 59.8293 42.878L59.851 42.8372C59.7709 42.8674 59.7052 42.9364 59.6787 43.0157C59.6492 43.0947 59.6475 43.1799 59.6653 43.2604C59.682 43.3409 59.7215 43.4183 59.7826 43.4784C59.8425 43.537 59.9167 43.5771 59.9939 43.6051C60.1501 43.6582 60.3156 43.6597 60.4759 43.6458C60.6359 43.6315 60.7958 43.6046 60.9548 43.5665C61.2764 43.514 61.5745 43.26 61.876 43.4613C62.1909 43.5942 62.5494 43.63 62.8956 43.5708C63.0687 43.5411 63.2394 43.4879 63.4001 43.4096C63.5611 43.3357 63.7088 43.2159 63.8437 43.1168C63.9142 43.0702 63.9888 43.0457 64.0695 43.0576C64.1504 43.0676 64.2332 43.1021 64.3222 43.1268C64.4987 43.1767 64.6829 43.2029 64.8685 43.2047C65.2436 43.2133 65.6084 43.0891 65.9546 42.9561C66.3044 42.8253 66.6586 42.693 67.0165 42.5592L66.9647 42.5403C67.0768 42.7357 67.344 42.8375 67.5731 42.7427C67.801 42.6444 67.9221 42.3568 67.8258 42.1178L67.7744 42.1766C68.165 42.2861 68.6567 41.943 68.6417 41.474L68.5641 41.5055C68.6357 41.5903 68.756 41.6219 68.8612 41.6059C68.9675 41.5911 69.0695 41.5404 69.145 41.4573C69.2927 41.2884 69.3202 41.0615 69.3439 40.8589L69.2647 40.8827C69.4363 41.0849 69.7727 41.1339 70.0045 40.9615C70.234 40.7847 70.2772 40.4184 70.0861 40.1878L70.0798 40.2533C70.2529 40.1162 70.3236 39.8722 70.2867 39.6495C70.2544 39.4282 70.1119 39.1972 69.8759 39.1189L69.8911 39.1987C70.1568 38.9792 70.1854 38.4918 69.8865 38.2379L69.8792 38.3151C70.0592 38.219 70.2043 38.0155 70.2214 37.7861L70.1319 37.8028C70.1564 37.8544 70.2017 37.9001 70.2564 37.9223C70.3108 37.945 70.3687 37.9476 70.4223 37.9407C70.5301 37.926 70.6266 37.875 70.7066 37.803C70.8606 37.6457 70.919 37.4312 70.9151 37.2191C70.9103 37.0065 70.8177 36.7911 70.6578 36.643C70.5001 36.494 70.2854 36.4027 70.064 36.404L70.1112 36.4439C70.1004 36.3699 70.0575 36.2936 69.9974 36.2402L70.0028 36.3053C70.067 36.2237 70.0928 36.1083 70.0772 36.0003L70.0748 36.0237C70.1653 35.7845 70.0679 35.5127 69.903 35.3249C69.7336 35.1301 69.495 35.0177 69.2625 34.9293L69.259 35.0206C69.4031 34.9787 69.528 34.8536 69.5731 34.6978L69.5568 34.7221C69.6555 34.6449 69.7562 34.5263 69.7852 34.3809L69.7768 34.3987C69.846 34.3133 69.8789 34.1762 69.8358 34.0599C69.7974 33.9443 69.7046 33.8439 69.5816 33.8059L69.5848 33.8975C69.6384 33.8792 69.6866 33.8272 69.6996 33.7704C69.7141 33.7137 69.7063 33.6586 69.6898 33.6092C69.6553 33.512 69.5846 33.4218 69.4746 33.3851C69.2718 33.3246 69.0758 33.3916 68.9029 33.3621L68.9211 33.3691C68.5402 33.127 68.0498 32.9902 67.5603 33.024L67.6021 33.1019C67.6863 32.9908 67.7776 32.8702 67.8691 32.7496L68.0711 32.4828C68.1364 32.3904 68.2101 32.3147 68.2695 32.2022C68.298 32.1456 68.3086 32.0731 68.2923 32.008C68.2763 31.9425 68.2396 31.8872 68.1969 31.8436C68.1121 31.7556 68.0025 31.7009 67.8982 31.6606C67.6869 31.5762 67.4607 31.5322 67.2347 31.5291C67.1213 31.528 67.0091 31.5361 66.8966 31.5558C66.8384 31.5673 66.7805 31.5849 66.7259 31.6185C66.6729 31.6499 66.6176 31.7124 66.6161 31.7892L66.6723 31.7432C66.4517 31.7085 66.2354 31.7606 66.0372 31.8239C65.9372 31.8571 65.8405 31.8881 65.7405 31.93C65.6431 31.972 65.539 32.0338 65.4795 32.1397L65.5698 32.1685C65.5899 31.966 65.7639 31.7961 65.8138 31.5593C65.8381 31.446 65.829 31.299 65.7244 31.2072C65.6758 31.1643 65.6158 31.1354 65.5492 31.1287C65.4839 31.12 65.4058 31.1441 65.3596 31.2009L65.4286 31.2675C65.4791 31.2235 65.5034 31.153 65.4986 31.0914C65.4952 31.0292 65.4717 30.9726 65.4379 30.9244C65.4034 30.8769 65.3553 30.8355 65.2984 30.8144C65.2446 30.793 65.1874 30.7849 65.1321 30.7843C65.0212 30.7843 64.9197 30.8112 64.8206 30.8376C64.7692 30.8528 64.7174 30.8715 64.6683 30.9044C64.6206 30.9348 64.5701 30.9955 64.572 31.068L64.6623 31.0454C64.5935 30.9127 64.4319 30.8769 64.3098 30.9044C64.1864 30.9272 64.0541 31.0246 64.0428 31.1717L64.1129 31.1337C63.904 31.0261 63.6339 31.1302 63.5502 31.3458L63.6075 31.3166C63.3684 31.253 63.1249 31.3944 63.024 31.6011L63.1121 31.6337C63.1574 31.4597 63.2027 31.2866 63.2476 31.114C63.2708 31.0333 63.2984 30.9287 63.2789 30.832C63.2702 30.7836 63.2585 30.7342 63.2238 30.6875C63.2077 30.6643 63.1804 30.6424 63.1479 30.632C63.1134 30.6201 63.0798 30.6288 63.0518 30.6381L63.0821 30.7266C63.2129 30.6906 63.2873 30.5604 63.298 30.4437C63.3114 30.3253 63.2763 30.1971 63.1847 30.1112C63.001 29.9442 62.7355 29.9562 62.5336 30.0414L62.5145 30.0494L62.508 30.0694C62.4724 30.1757 62.4379 30.2793 62.4032 30.3828L62.462 30.3537C62.2709 30.2902 62.0527 30.3583 61.9319 30.5153C61.8133 30.6739 61.8061 30.8986 61.913 31.0628L61.9746 30.9984C61.8998 30.953 61.8065 30.9702 61.7452 31.0099C61.6814 31.0491 61.6326 31.1103 61.6118 31.1836C61.5736 31.3268 61.6198 31.461 61.6573 31.5784L61.7189 31.5228C61.5688 31.456 61.4025 31.5207 61.3027 31.6215C61.1997 31.7202 61.1368 31.8835 61.1977 32.0295L61.2476 31.9683C61.0242 31.9254 60.7973 31.9454 60.5915 32.02L60.6494 32.074C60.7043 31.8725 60.6127 31.6519 60.4381 31.5476C60.262 31.4454 60.031 31.4723 59.8839 31.6081L59.9549 31.6246C59.8447 31.3597 59.4987 31.2706 59.279 31.4306L59.3423 31.443C59.2799 31.3435 59.1842 31.2725 59.0779 31.2348C58.9729 31.1966 58.8502 31.1901 58.7417 31.2415C58.6344 31.296 58.565 31.4103 58.5615 31.5265C58.5563 31.6432 58.6018 31.748 58.6545 31.8389C58.7641 32.0232 58.9213 32.1573 59.0573 32.3013C59.1972 32.4442 59.3363 32.5861 59.474 32.7271L59.5124 32.6572C59.2009 32.5913 58.8938 32.526 58.591 32.4618C58.4398 32.4297 58.2897 32.3978 58.1405 32.3661C58.0637 32.3542 57.9991 32.3254 57.903 32.3299C57.8542 32.3338 57.8075 32.3674 57.7824 32.3995C57.755 32.4316 57.7357 32.4633 57.7134 32.485C57.6713 32.5286 57.5993 32.5442 57.5258 32.5759C57.4492 32.6056 57.3809 32.6761 57.3564 32.7574C57.3113 32.9238 57.3779 33.0862 57.4796 33.2029C57.5893 33.3244 57.7386 33.3723 57.8761 33.4166C58.0155 33.4587 58.1539 33.4908 58.2769 33.5502L58.2765 33.4821C58.0841 33.5797 57.9084 33.6688 57.7342 33.7573L57.7837 33.7727C57.5846 33.4383 57.1295 33.3752 56.8569 33.5849L56.9083 33.5918C56.8172 33.4671 56.6543 33.4383 56.5244 33.4515C56.3897 33.4624 56.2632 33.5025 56.143 33.5452C56.0227 33.5888 55.9005 33.6385 55.7986 33.7239C55.6962 33.807 55.6249 33.9356 55.6207 34.0682C55.6121 34.3341 55.781 34.5685 55.9938 34.6868C56.2072 34.8097 56.4448 34.8501 56.6679 34.8902L56.6415 34.8605C56.648 34.9518 56.5829 35.0325 56.5003 35.08C56.4174 35.1299 56.3239 35.1529 56.2253 35.1603C56.1268 35.1698 56.0255 35.1733 55.9255 35.198C55.8255 35.2203 55.7281 35.2776 55.6663 35.3598C55.5418 35.5218 55.5086 35.7201 55.3874 35.8476C55.3318 35.9142 55.242 35.9368 55.1659 36.006C55.0887 36.079 55.0765 36.1871 55.0783 36.2758C55.0891 36.4534 55.0998 36.6276 55.1097 36.7979C55.1147 36.8829 55.1449 36.9835 55.2238 37.038C55.2997 37.0935 55.3943 37.1022 55.4782 37.0918C55.563 37.0805 55.6431 37.0501 55.7134 37.005C55.783 36.9579 55.8387 36.9011 55.8932 36.8449C56.0003 36.7324 56.1005 36.6174 56.23 36.5577L56.2042 36.5185C56.0654 36.6475 55.9316 36.7746 55.8272 36.9185C55.7238 37.0618 55.647 37.2219 55.6366 37.3898C55.6283 37.5557 55.6789 37.716 55.773 37.837C55.8652 37.9589 56.0188 38.0322 56.1608 38.0079L56.1556 38.0077C56.3411 38.0405 56.4699 38.0125 56.5801 37.9678L56.5567 37.9561C56.6751 38.4647 56.6658 38.8304 56.6424 39.1269L56.6497 39.117C56.4474 39.2007 56.273 39.2831 56.1459 39.385C56.0177 39.4855 55.9385 39.5983 55.8979 39.6961C55.858 39.7948 55.8541 39.875 55.8563 39.9262C55.8589 39.9776 55.8669 40.0019 55.8669 40.0019C55.8752 40.0041 55.8318 39.8967 55.9094 39.7011C55.9509 39.6063 56.0305 39.4968 56.1571 39.3996C56.2834 39.3013 56.4563 39.2217 56.6591 39.1395L56.6658 39.1367L56.6666 39.1293C56.6935 38.8311 56.7063 38.4626 56.5899 37.9483L56.5853 37.929L56.5667 37.9366C56.4623 37.978 56.3398 38.0038 56.1626 37.9717L56.1593 37.9711L56.1571 37.9715C56.0268 37.9928 55.8897 37.9262 55.8042 37.8127C55.7173 37.6997 55.67 37.5475 55.6787 37.3922C55.6891 37.2373 55.7628 37.0826 55.8637 36.9451C55.9656 36.8061 56.0975 36.6816 56.2365 36.5536L56.3469 36.4519L56.2103 36.5144C56.0678 36.5794 55.9637 36.7003 55.8572 36.81C55.8038 36.8649 55.7479 36.9206 55.6856 36.9623C55.622 37.0028 55.5481 37.0304 55.4717 37.0399C55.396 37.0492 55.3149 37.0397 55.2553 36.995C55.1935 36.9519 55.1692 36.8751 55.1637 36.7931C55.1542 36.6241 55.1446 36.4515 55.1347 36.2751C55.1334 36.1901 55.1464 36.1018 55.2056 36.0474C55.2624 35.9923 55.362 35.9645 55.4294 35.8877C55.5659 35.7415 55.5993 35.5405 55.7136 35.3975C55.8244 35.2444 56.0335 35.2373 56.2309 35.2223C56.3317 35.2153 56.4404 35.1902 56.533 35.1342C56.6252 35.0826 56.7139 34.9809 56.7057 34.8566L56.704 34.8314L56.6792 34.8269C56.4562 34.7865 56.2261 34.7451 56.0272 34.6295C55.8307 34.5208 55.6804 34.3031 55.6889 34.0721C55.6936 33.9578 55.7524 33.8515 55.8431 33.7771C55.9335 33.7014 56.0487 33.6537 56.1665 33.6116C56.2851 33.5697 56.4057 33.5324 56.5298 33.5229C56.6517 33.5114 56.7805 33.5389 56.8499 33.6348L56.8718 33.6652L56.9013 33.6417C57.1347 33.4585 57.5507 33.5187 57.7186 33.8087L57.7366 33.84L57.7681 33.8241C57.9425 33.7361 58.1184 33.6472 58.3108 33.55L58.3795 33.5151L58.3103 33.4817C58.1767 33.417 58.0342 33.3845 57.8986 33.3431C57.7657 33.301 57.6253 33.2511 57.5379 33.1511C57.4492 33.052 57.3956 32.9051 57.4314 32.7813C57.4518 32.7212 57.4946 32.6739 57.5579 32.6483C57.6193 32.6201 57.7026 32.6062 57.7696 32.5416C57.8297 32.4772 57.8579 32.4115 57.9125 32.4095C57.9689 32.4047 58.0507 32.4321 58.1236 32.4449C58.2726 32.4768 58.4229 32.5091 58.5741 32.5414C58.8769 32.6062 59.1838 32.6718 59.495 32.7386L59.6295 32.7674L59.5334 32.6689C59.3957 32.5277 59.2569 32.3857 59.1172 32.2425C58.9795 32.0967 58.8259 31.9636 58.7276 31.7957C58.679 31.7126 58.6422 31.6204 58.6469 31.5309C58.6495 31.4419 58.7031 31.3575 58.7801 31.3185C58.9424 31.2435 59.1714 31.3304 59.2679 31.4877L59.2933 31.5291L59.3313 31.4998C59.4965 31.3725 59.7939 31.4506 59.8727 31.656L59.8963 31.717L59.9438 31.6723C60.0594 31.5636 60.2548 31.5413 60.3932 31.6237C60.5318 31.7046 60.6088 31.8913 60.5637 32.0499L60.5401 32.1334L60.6218 32.1039C60.8125 32.0349 61.0237 32.0165 61.2305 32.0566L61.3144 32.0729L61.2808 31.9955C61.1899 31.7864 61.4664 31.5089 61.682 31.6057L61.7757 31.6478L61.7434 31.5499C61.7052 31.4335 61.6699 31.3144 61.6994 31.2081C61.7232 31.1114 61.8495 31.0276 61.9278 31.0771L62.107 31.1903L61.9894 31.0125C61.9044 30.8838 61.9102 30.6949 62.0052 30.5711C62.0991 30.4468 62.2824 30.3897 62.4321 30.4414L62.4761 30.4563L62.4911 30.4121C62.5256 30.3086 62.5603 30.2049 62.5958 30.0989L62.5703 30.1266C62.7488 30.0501 62.9804 30.0475 63.1207 30.1791C63.2554 30.2976 63.2311 30.5871 63.0563 30.6364L63.0869 30.7251C63.1151 30.716 63.1283 30.719 63.1489 30.7444C63.1682 30.7689 63.1797 30.8084 63.1862 30.8468C63.2012 30.9277 63.1817 31.0003 63.1565 31.0901C63.1114 31.2628 63.0661 31.4359 63.0205 31.6098L63.1088 31.6423C63.1899 31.4729 63.3992 31.356 63.5819 31.4081L63.6244 31.4202L63.6394 31.3788C63.6955 31.2207 63.9185 31.1352 64.0675 31.2174L64.1343 31.2543L64.1376 31.1795C64.1467 30.9893 64.4929 30.9172 64.5777 31.0899L64.6835 31.3055L64.6679 31.0673C64.6636 31.004 64.7579 30.9535 64.8466 30.9298C64.9421 30.904 65.039 30.8797 65.1314 30.8802C65.2249 30.881 65.3119 30.9086 65.3596 30.9804C65.4103 31.0489 65.4212 31.1491 65.3648 31.1955L65.4336 31.2621C65.4804 31.2009 65.5943 31.2179 65.6602 31.279C65.7279 31.3363 65.7398 31.4426 65.7192 31.5397C65.6826 31.741 65.5058 31.9089 65.4737 32.1579L65.4431 32.3943L65.5639 32.1868C65.6546 32.031 65.8778 31.9842 66.0667 31.9161C66.2604 31.854 66.4619 31.8078 66.6571 31.8391L66.7133 31.848L66.7131 31.7931C66.7128 31.7202 66.818 31.6677 66.9143 31.6512C67.0185 31.633 67.1265 31.6252 67.2334 31.6263C67.4477 31.6291 67.6622 31.671 67.8622 31.7508C67.9635 31.7898 68.0568 31.8384 68.1268 31.9109C68.1977 31.982 68.2262 32.0755 68.1815 32.1607C68.1379 32.246 68.0574 32.3351 67.9936 32.4241L67.7915 32.6911C67.7 32.8117 67.6086 32.932 67.5247 33.0431L67.4601 33.1283L67.5666 33.121C68.0346 33.0886 68.5053 33.2199 68.8693 33.4513L68.8779 33.4567L68.8877 33.4582C69.0931 33.4879 69.2844 33.425 69.4456 33.4778C69.5154 33.4994 69.5735 33.5682 69.5981 33.6404C69.6237 33.7148 69.6096 33.7879 69.5501 33.807L69.4037 33.8539L69.5534 33.8988C69.6421 33.9252 69.7154 34.0029 69.744 34.0905C69.775 34.1794 69.754 34.2697 69.6989 34.3417L69.6928 34.3497L69.6907 34.3597C69.6672 34.4788 69.5859 34.5759 69.4966 34.6464L69.4846 34.6562L69.4803 34.6709C69.4454 34.7943 69.3417 34.8972 69.2319 34.928L69.0914 34.9674L69.2282 35.0193C69.4562 35.1056 69.6798 35.214 69.8306 35.388C69.9802 35.5576 70.0598 35.7982 69.9848 35.9903L69.9805 36.0016L69.9824 36.014C69.995 36.0994 69.9735 36.1886 69.9275 36.2463L69.8996 36.2814L69.933 36.3113C69.9792 36.3526 70.0089 36.4068 70.0171 36.4595L70.0232 36.4998L70.0648 36.4996C70.259 36.4981 70.4522 36.5794 70.5921 36.7124C70.7344 36.8443 70.8153 37.0317 70.8201 37.2223C70.8264 37.4089 70.7654 37.6101 70.642 37.7338C70.5774 37.7928 70.4934 37.8364 70.4097 37.8472C70.3255 37.8596 70.2483 37.831 70.2171 37.7624L70.1403 37.5941L70.1275 37.7791C70.1138 37.9737 69.987 38.1515 69.8345 38.2329L69.7729 38.2656L69.8271 38.3103C70.0774 38.5164 70.0538 38.9506 69.8314 39.1274L69.7646 39.1805L69.8468 39.2072C70.0403 39.2701 70.1663 39.4673 70.1954 39.6638C70.2284 39.8614 70.1648 40.0692 70.0223 40.1817L69.985 40.2112L70.016 40.2472C70.1733 40.4309 70.1362 40.75 69.9492 40.889C69.7631 41.0318 69.4699 40.9897 69.3337 40.8248L69.266 40.7428L69.2543 40.8487C69.2321 41.0511 69.2013 41.2586 69.0784 41.3977C68.963 41.5295 68.7313 41.5684 68.6309 41.4473L68.5454 41.3439L68.5532 41.4788C68.5645 41.672 68.4554 41.8588 68.3058 41.9729C68.1565 42.0898 67.9615 42.1373 67.7971 42.0924L67.7108 42.0688L67.7453 42.1512C67.8247 42.3403 67.7212 42.5882 67.539 42.6633C67.3564 42.7418 67.1263 42.6548 67.0386 42.4982L67.0208 42.4663L66.9866 42.4794C66.6287 42.6136 66.2749 42.7466 65.9255 42.8778C65.578 43.0116 65.2288 43.1305 64.8692 43.1229C64.6907 43.1214 64.5137 43.0967 64.3443 43.0489C64.2601 43.0264 64.176 42.9902 64.0792 42.9776C63.9812 42.9622 63.876 42.9973 63.8003 43.0496C63.6502 43.16 63.5231 43.265 63.3654 43.3389C63.2118 43.4138 63.0483 43.4652 62.8822 43.494C62.5503 43.5513 62.2065 43.5177 61.9048 43.3912C61.8291 43.36 61.7497 43.3227 61.6593 43.311C61.5677 43.2988 61.479 43.3207 61.3996 43.3476C61.2433 43.4057 61.0938 43.4576 60.9374 43.4949C60.7823 43.5326 60.6255 43.5593 60.4691 43.5736C60.3145 43.5877 60.1579 43.5853 60.0173 43.5376C59.8768 43.4903 59.7594 43.3877 59.7338 43.2452C59.6998 43.1097 59.7486 42.9472 59.8746 42.9019L59.9041 42.8915L59.8963 42.8611C59.8646 42.7392 59.8019 42.6223 59.7013 42.5418C59.6028 42.4587 59.4575 42.4334 59.3391 42.4785C59.22 42.5151 59.1187 42.6481 59.1538 42.7785C59.1788 42.8971 59.2933 43.0103 59.4276 42.98L59.3929 42.9301C59.3102 43.0537 59.1415 43.0895 59.0001 43.0552C58.8565 43.0231 58.7274 42.9233 58.6862 42.7871C58.5984 42.5069 58.796 42.2026 59.0447 42.1048L59.081 42.0907L59.0578 42.0597C58.9142 41.869 58.8296 41.6445 58.7996 41.4419L58.7814 41.3187L58.7446 41.4378C58.6686 41.6835 58.3743 41.8098 58.1693 41.7393L58.1414 41.7297L58.1351 41.7592C58.0945 41.9449 58.0095 42.1204 57.8763 42.2421C57.7457 42.3666 57.5603 42.4158 57.3946 42.3811C57.2284 42.3507 57.0892 42.2182 57.0842 42.057C57.0705 41.902 57.1573 41.7371 57.2996 41.7013L57.3423 41.6905L57.3069 41.6625C57.0584 41.4643 57.172 41.0242 57.4371 40.9535L57.4612 40.9469L57.4488 40.925C57.2835 40.6368 57.3772 40.28 57.5731 40.1065L57.549 40.0846C57.4061 40.2646 57.12 40.2314 57.0154 40.0859L56.9974 40.06L56.9911 40.0913C56.9699 40.2071 56.8796 40.2871 56.7868 40.329C56.6925 40.3713 56.5946 40.386 56.5048 40.3891C56.3259 40.391 56.1734 40.352 56.0693 40.2923C55.9641 40.231 55.9162 40.1462 55.8945 40.0902C55.8726 40.0329 55.8695 40.0013 55.8669 40.0019Z" fill="#335863"/>
                    <path d="M68.1528 44.2491L65.5715 36.8016C64.9583 34.774 63.2673 33.4411 61.2575 34.1101L61.0755 34.1827C59.2423 34.9143 58.2786 36.9309 58.8606 38.817C59.4017 40.5709 60.0218 42.5013 60.3969 43.4084C61.1736 45.2867 63.1786 44.8267 63.1786 44.8267C63.1827 44.8254 63.3402 45.2694 63.5372 45.8322C63.5372 45.8322 63.858 47.7217 65.3353 47.2696C66.8126 46.8174 68.1528 44.2491 68.1528 44.2491Z" fill="#D88875"/>
                    <path d="M63.1836 44.8715C63.1836 44.8715 64.4011 44.4663 65.3513 43.1641C65.3513 43.1641 65.3443 44.8346 63.3929 45.4164L63.1836 44.8715Z" fill="#915A53"/>
                    <path d="M59.9258 40.1651C59.9774 40.3096 60.1425 40.3849 60.2943 40.3335C60.4457 40.2823 60.5268 40.1239 60.475 39.9795C60.4234 39.8352 60.2583 39.7598 60.1069 39.811C59.9551 39.8624 59.874 40.0209 59.9258 40.1651Z" fill="#0C2B34"/>
                    <path d="M59.5829 39.4676C59.6302 39.4893 59.774 39.2568 60.0644 39.1418C60.3529 39.0227 60.6253 39.0869 60.6427 39.039C60.6518 39.0171 60.5926 38.9672 60.4729 38.9366C60.3549 38.906 60.1731 38.9026 59.9926 38.9755C59.8124 39.0486 59.687 39.1759 59.6268 39.2787C59.5649 39.3828 59.5599 39.4585 59.5829 39.4676Z" fill="#0C2B34"/>
                    <path d="M62.6133 39.2864C62.6652 39.4307 62.83 39.5059 62.9818 39.4545C63.1332 39.4033 63.2143 39.245 63.1627 39.1005C63.1109 38.9563 62.9458 38.8808 62.7944 38.9322C62.6426 38.9834 62.5615 39.142 62.6133 39.2864Z" fill="#0C2B34"/>
                    <path d="M62.4614 38.4421C62.5092 38.464 62.6532 38.2313 62.9434 38.1163C63.2319 37.9974 63.5043 38.0616 63.5216 38.0135C63.5307 37.9916 63.4715 37.9417 63.3518 37.9113C63.2336 37.8805 63.052 37.8773 62.8716 37.9502C62.6914 38.0232 62.566 38.1503 62.5055 38.2532C62.4439 38.3573 62.4391 38.433 62.4614 38.4421Z" fill="#0C2B34"/>
                    <path d="M62.3017 41.0927C62.2965 41.0758 62.1039 41.1166 61.7968 41.1958C61.7196 41.2177 61.6437 41.2309 61.6109 41.1854C61.5723 41.1389 61.5714 41.0465 61.5727 40.9461C61.571 40.739 61.5688 40.5221 61.5667 40.2948C61.5504 39.3701 61.5072 38.622 61.4699 38.6231C61.4326 38.624 61.4157 39.374 61.432 40.2985C61.4376 40.5258 61.443 40.7424 61.4485 40.9498C61.4543 41.045 61.4441 41.1598 61.5263 41.2556C61.5682 41.3031 61.6387 41.3216 61.6912 41.3155C61.7443 41.3109 61.7866 41.2951 61.8241 41.2827C62.1243 41.1812 62.3072 41.1097 62.3017 41.0927Z" fill="#0C2B34"/>
                    <path d="M62.0202 37.4939C62.0801 37.5613 62.3551 37.4088 62.7119 37.3149C63.067 37.2134 63.381 37.2041 63.3982 37.1156C63.4051 37.0735 63.3275 37.0184 63.1863 36.9859C63.0457 36.9536 62.8414 36.9505 62.628 37.0089C62.4146 37.0676 62.2404 37.1746 62.1363 37.2744C62.0313 37.3743 61.9929 37.4613 62.0202 37.4939Z" fill="#0C2B34"/>
                    <path d="M59.2999 38.434C59.3762 38.4813 59.5521 38.337 59.7931 38.2433C60.0311 38.1412 60.2575 38.121 60.2788 38.0338C60.287 37.9924 60.2297 37.9377 60.1165 37.9084C60.0048 37.8787 59.8378 37.8826 59.6732 37.9499C59.5088 38.0173 59.3867 38.1314 59.3279 38.231C59.2676 38.3312 59.2652 38.4101 59.2999 38.434Z" fill="#0C2B34"/>
                    <path d="M62.3051 41.9513C62.3853 42.0474 62.4671 42.145 62.5714 42.2144C62.6753 42.2838 62.807 42.3229 62.9276 42.289C63.0562 42.2532 63.1534 42.1381 63.1892 42.0094C63.2249 41.881 63.2056 41.742 63.1584 41.6173C63.1152 41.5045 63.0176 41.3852 62.8994 41.4095C62.8504 41.4195 62.8098 41.4531 62.7714 41.4856C62.599 41.6325 62.4266 41.7791 62.2539 41.9257" fill="#915A53"/>
                    <path d="M62.7004 42.3425C62.6971 42.3225 62.8459 42.3325 63.0062 42.1976C63.0834 42.1321 63.1578 42.0286 63.1747 41.8989C63.1921 41.7705 63.153 41.6174 63.0532 41.5052C63.0292 41.4768 62.9997 41.4534 62.9717 41.4332C62.9398 41.4161 62.9446 41.4159 62.9199 41.428C62.8977 41.4428 62.8643 41.4742 62.8363 41.4974C62.8077 41.5219 62.7795 41.546 62.7515 41.5699C62.6407 41.6638 62.5398 41.7473 62.4542 41.8163C62.2826 41.9542 62.1713 42.0336 62.1609 42.0221C62.1507 42.0104 62.2433 41.9097 62.4017 41.7566C62.4806 41.68 62.5759 41.5905 62.683 41.4922C62.7099 41.4675 62.7374 41.4423 62.7654 41.4169C62.7958 41.3909 62.8173 41.3666 62.8598 41.3356C62.881 41.3215 62.9129 41.3068 62.9494 41.3089C62.9851 41.3113 63.0118 41.3263 63.0326 41.3393C63.071 41.366 63.1068 41.3948 63.1372 41.4304C63.2615 41.5705 63.3044 41.757 63.2771 41.9147C63.2493 42.0759 63.1502 42.1941 63.0548 42.2605C62.9582 42.3292 62.863 42.3518 62.7993 42.3561C62.7346 42.36 62.7001 42.349 62.7004 42.3425Z" fill="#0C2B34"/>
                    <path d="M57.7841 37.4665C57.762 37.3661 57.7247 37.2678 57.7164 37.1659C57.7038 37.0021 57.7689 36.8531 57.8325 36.7137C58.0574 36.2187 58.2977 35.7042 58.7079 35.411C58.9586 35.2316 59.2577 35.1472 59.51 34.9704C59.6659 34.8613 59.8006 34.719 59.9451 34.5915C60.5407 34.0657 61.2905 33.8005 62.049 33.6469C62.4728 33.5612 62.9092 33.5074 63.3476 33.5764C63.8291 33.6521 64.2957 33.8727 64.7455 34.1189C65.417 34.4861 66.0771 34.9231 66.6143 35.5302C67.0269 35.9968 67.3683 36.5822 67.4561 37.2193C67.5442 37.8563 67.3332 38.5393 66.859 38.8152C66.7694 38.758 66.6799 38.7007 66.5905 38.6432L66.1719 38.3962C66.2732 38.52 66.2222 38.5276 66.1302 38.6408C66.0378 38.754 65.8597 38.756 65.7478 38.6454C65.6903 38.7998 65.4364 38.7337 65.4179 38.5595C65.3201 38.659 65.1214 38.5467 65.1162 38.389C64.9958 38.4808 64.8514 38.2853 64.7375 38.1593C64.6753 38.0905 64.6019 38.0374 64.5334 37.9769C64.3189 37.7869 64.1543 37.519 64.0727 37.2275C63.8376 37.0781 63.7025 36.7816 63.5832 36.5048C63.509 36.3319 63.4346 36.1593 63.36 35.9864C63.3144 35.9545 63.2689 35.9228 63.2233 35.891C63.268 36.0189 63.206 36.159 63.1116 36.2265C63.0173 36.2942 62.8986 36.3065 62.7843 36.3169C62.6713 36.3278 62.5581 36.3382 62.4449 36.3488C62.3839 36.3879 62.323 36.4269 62.262 36.4657C62.3698 36.6154 62.3661 36.8221 62.3564 37.0065C62.3496 37.1336 62.3377 37.2735 62.2566 37.3529C62.1755 37.432 62.0041 37.3813 61.9974 37.2527C61.9503 37.3544 61.8141 37.3589 61.725 37.288C61.6356 37.2173 61.5857 37.0961 61.5551 36.9785C61.4801 36.692 61.4903 36.3853 61.5835 36.1241C61.4491 36.353 61.3141 36.582 61.1797 36.8108C61.1504 36.8612 61.1179 36.9139 61.068 36.9347C61.1105 37.0245 61.0419 37.1299 60.9589 37.1438C60.8756 37.1577 60.7899 37.1106 60.711 37.0648C60.5333 36.962 60.3179 36.7618 60.3917 36.5653C60.3246 36.5718 60.2605 36.4742 60.2858 36.4044C60.1223 36.6269 59.9585 36.8497 59.795 37.0724C59.8473 37.0169 59.9459 37.0948 59.9561 37.1806C59.9663 37.2665 59.9216 37.3412 59.8794 37.4071C59.9587 37.4756 60.0177 37.5771 60.0407 37.6858C60.1245 37.5498 60.3513 37.6891 60.363 37.8635C60.3743 38.0381 60.2446 38.1708 60.1051 38.2233C59.9902 38.2667 59.8303 38.2532 59.7687 38.122C59.6386 38.1923 59.4484 38.0407 59.4516 37.8691C59.3712 37.9658 59.2297 37.8112 59.1837 37.6763C59.1035 37.4394 59.0677 37.1872 59.0775 36.9421C59.0703 36.9633 59.0512 36.9796 59.0306 36.9718L59.0091 36.9492C58.9777 37.2529 58.9462 37.5568 58.9148 37.8604C58.8881 38.1181 58.8621 38.3853 58.9324 38.6421C58.961 38.7467 58.9909 38.8924 58.9068 38.9276C58.8838 38.9369 58.8578 38.9339 58.8328 38.9297C58.5452 38.8805 58.2767 38.6833 58.0667 38.4339C57.9964 38.3502 57.9307 38.2586 57.8893 38.1539C57.804 37.9368 57.834 37.6945 57.7841 37.4665Z" fill="#0C2B34"/>
                    <path d="M60.3394 36.1501C60.345 36.1438 60.2654 36.1261 60.2134 36.0187C60.1893 35.9671 60.1776 35.8912 60.2151 35.8213C60.25 35.7526 60.3333 35.6912 60.4285 35.6951L60.4832 35.6975L60.4476 35.6552C60.388 35.5845 60.3734 35.4604 60.4335 35.3697C60.4914 35.2797 60.6315 35.2391 60.7361 35.2934L60.7651 35.2446L60.7398 35.219C60.7174 35.186 60.7133 35.1392 60.7263 35.1001C60.7378 35.0606 60.7695 35.0298 60.8061 35.0097C60.8437 34.9897 60.8866 34.9804 60.9282 34.9799C60.969 34.9784 61.0187 34.9934 61.0723 34.9706C61.1269 34.9435 61.1402 34.8934 61.164 34.8656C61.1859 34.8327 61.2135 34.8058 61.2406 34.7806C61.2972 34.7322 61.3605 34.7001 61.4213 34.6802C61.5436 34.6394 61.652 34.6494 61.7217 34.6663C61.7924 34.6837 61.8284 34.7043 61.8308 34.6997C61.8321 34.6978 61.7997 34.6698 61.7277 34.6448C61.6568 34.6208 61.5421 34.6032 61.4093 34.6418C61.3436 34.6607 61.274 34.693 61.2104 34.7444C61.1796 34.7711 61.1486 34.8004 61.1237 34.8364C61.0959 34.8717 61.0794 34.9121 61.0508 34.9229C61.0215 34.9364 60.9784 34.9266 60.9282 34.9257C60.8786 34.9255 60.8272 34.9357 60.7801 34.9604C60.7337 34.9849 60.6899 35.0268 60.6725 35.0825C60.655 35.1366 60.6584 35.1995 60.6929 35.2513L60.7337 35.2916L60.7625 35.2428C60.6281 35.1754 60.4619 35.2255 60.3882 35.3398C60.3151 35.455 60.3357 35.6003 60.4107 35.6866L60.4303 35.6467C60.3114 35.6454 60.2183 35.7213 60.1797 35.8037C60.1387 35.889 60.1578 35.9766 60.1882 36.0311C60.2192 36.0881 60.2611 36.1193 60.2906 36.1349C60.3207 36.1503 60.3389 36.1521 60.3394 36.1501Z" fill="#335863"/>
                    <path d="M59.1386 36.8954C59.1431 36.8891 59.0637 36.8761 58.9919 36.7743C58.9581 36.7249 58.9297 36.6505 58.9451 36.5668C58.959 36.4846 59.0165 36.3932 59.1123 36.3512L59.1496 36.3349L59.1147 36.3128C59.029 36.259 58.9412 36.1638 58.9371 36.0451C58.934 35.9874 58.9624 35.931 59.0102 35.892C59.0568 35.8532 59.1249 35.8367 59.1761 35.8668L59.3771 35.9855L59.2084 35.8234C59.1505 35.7675 59.1175 35.6796 59.1253 35.5924C59.131 35.505 59.1843 35.423 59.2652 35.3788C59.3223 35.3467 59.3891 35.3337 59.4509 35.3445L59.5229 35.3569L59.4778 35.299C59.4142 35.217 59.4774 35.0821 59.5674 35.0424C59.6626 34.9966 59.7749 35.0096 59.8738 35.0309L59.9337 35.0437L59.9012 34.9923C59.8604 34.9287 59.8734 34.842 59.9103 34.7808C59.9487 34.7183 60.0101 34.6754 60.0712 34.6448C60.1962 34.5843 60.3191 34.5606 60.4198 34.5526C60.6234 34.5392 60.7395 34.5812 60.7408 34.5726C60.7414 34.5702 60.7139 34.5583 60.6595 34.545C60.6048 34.5322 60.523 34.5186 60.4183 34.522C60.3139 34.5259 60.1864 34.5459 60.0528 34.6066C59.9869 34.6376 59.9172 34.6828 59.8699 34.7561C59.8255 34.8279 59.8049 34.9313 59.8578 35.0196L59.8851 34.981C59.7828 34.9582 59.6602 34.9391 59.5435 34.9931C59.4852 35.0205 59.4377 35.0721 59.4132 35.1337C59.388 35.194 59.3865 35.2749 59.4335 35.3341L59.4607 35.2888C59.3847 35.2755 59.3049 35.2912 59.2373 35.3293C59.1418 35.381 59.075 35.4829 59.0692 35.5879C59.0609 35.6918 59.0993 35.7948 59.1711 35.8629L59.2034 35.8195C59.1255 35.7751 59.0327 35.8033 58.9768 35.8512C58.9184 35.8989 58.8822 35.9746 58.8872 36.0466C58.8959 36.1922 58.998 36.2926 59.0924 36.3499L59.0947 36.3117C58.9837 36.3637 58.9236 36.4685 58.9108 36.5613C58.8972 36.6568 58.9329 36.7377 58.9724 36.7887C59.0125 36.8409 59.0574 36.868 59.0887 36.8817C59.1199 36.8952 59.1381 36.8969 59.1386 36.8954Z" fill="#335863"/>
                    <path d="M56.271 37.9568C56.2786 37.9578 56.2365 37.8882 56.2981 37.7884C56.3276 37.7407 56.381 37.6924 56.4588 37.6715C56.536 37.6485 56.6302 37.6505 56.7343 37.6579L56.7675 37.66L56.754 37.6292C56.7133 37.5366 56.772 37.4087 56.8779 37.3468C56.9863 37.2833 57.1312 37.2863 57.2794 37.2972L57.4659 37.3108L57.2902 37.2455C57.1948 37.21 57.1683 37.0618 57.2251 36.9655C57.285 36.8649 57.4117 36.8124 57.5388 36.7879L57.5555 36.7848L57.6648 36.7638L57.5589 36.7295C57.429 36.6879 57.3995 36.4894 57.4874 36.3975C57.5752 36.2977 57.7312 36.2847 57.8435 36.3304L57.9802 36.386L57.8711 36.2868C57.7309 36.1597 57.6943 35.9611 57.7346 35.8123C57.7741 35.6587 57.891 35.5607 57.9953 35.5155C58.1016 35.4685 58.1973 35.4676 58.2595 35.4743C58.3222 35.4819 58.355 35.4949 58.3565 35.4912L58.3335 35.4791C58.3183 35.4719 58.294 35.4641 58.2621 35.4578C58.1986 35.4455 58.0977 35.4409 57.983 35.4863C57.8711 35.5296 57.7398 35.6322 57.6926 35.8008C57.6453 35.963 57.6798 36.1799 57.8361 36.3257L57.8635 36.2823C57.7342 36.2291 57.5574 36.2383 57.4453 36.361C57.3898 36.4222 57.3705 36.5113 57.3854 36.5922C57.3995 36.6727 57.4533 36.7566 57.542 36.784L57.5453 36.7289L57.5277 36.7321C57.3948 36.7586 57.2516 36.8126 57.1766 36.9375C57.1412 37.0002 57.1325 37.0729 57.1466 37.1397C57.1601 37.2063 57.205 37.2709 57.2713 37.2954L57.2824 37.2438C57.1345 37.2349 56.9779 37.2306 56.8529 37.3056C56.7326 37.3789 56.6642 37.528 56.7167 37.6455L56.7365 37.6171C56.6315 37.6125 56.5319 37.6128 56.4495 37.6407C56.3656 37.6663 56.3066 37.7238 56.2786 37.777C56.2487 37.8307 56.2467 37.8815 56.2528 37.9123C56.2595 37.9438 56.2701 37.9574 56.271 37.9568Z" fill="#335863"/>
                    <path d="M56.9805 34.7544C56.9803 34.7568 57.0078 34.7635 57.0592 34.7594C57.1106 34.7561 57.1846 34.7379 57.2733 34.7093C57.3611 34.6826 57.4713 34.644 57.5902 34.6665C57.6492 34.678 57.704 34.7101 57.7344 34.7678C57.7663 34.8221 57.7711 34.8995 57.7251 34.9429L57.77 34.9585C57.7609 34.8856 57.8344 34.8164 57.8988 34.7477C57.9648 34.6789 58.0361 34.611 58.1214 34.5646C58.2075 34.5162 58.3038 34.5019 58.3914 34.5295C58.478 34.554 58.5489 34.6188 58.5612 34.6973L58.5721 34.7665L58.6096 34.7073C58.6888 34.5835 58.8068 34.5004 58.9219 34.4585C59.0369 34.4136 59.1488 34.4065 59.2384 34.4141C59.4204 34.4316 59.5102 34.505 59.5143 34.4954C59.5158 34.4932 59.4948 34.4755 59.4508 34.4494C59.4065 34.4245 59.336 34.3952 59.2419 34.3818C59.1486 34.369 59.0304 34.3722 58.9068 34.4165C58.7829 34.4577 58.6536 34.5442 58.5647 34.6791L58.6135 34.6891C58.5985 34.585 58.5075 34.5045 58.4075 34.4759C58.307 34.4425 58.1882 34.4609 58.0943 34.5147C57.9999 34.5661 57.9253 34.6388 57.8585 34.7093C57.8255 34.7451 57.7921 34.7785 57.7626 34.8192C57.7338 34.8587 57.7097 34.9106 57.7173 34.9654L57.7247 35.0188L57.7622 34.981C57.8314 34.9112 57.8168 34.8071 57.7774 34.7433C57.7396 34.6733 57.6652 34.6327 57.5986 34.6227C57.4616 34.6013 57.3496 34.6479 57.2629 34.6783C57.1757 34.7114 57.1065 34.7336 57.057 34.742C57.0078 34.7513 56.9807 34.7507 56.9805 34.7544Z" fill="#335863"/>
                    <path d="M59.3751 32.9595C59.3779 32.9664 59.428 32.9346 59.5234 32.938C59.5701 32.9409 59.6278 32.9519 59.6844 32.9849C59.741 33.0159 59.7963 33.0695 59.8241 33.1424L59.8351 33.171L59.8601 33.1534C59.9234 33.109 60.0299 33.1363 60.0913 33.2074C60.154 33.2805 60.1739 33.3909 60.1887 33.5041L60.2032 33.6154L60.244 33.5089L60.2503 33.4922C60.2787 33.4248 60.3453 33.3779 60.4145 33.3608C60.4845 33.3421 60.5559 33.3536 60.6146 33.3864C60.7339 33.4523 60.7964 33.574 60.817 33.6755C60.8387 33.7796 60.8305 33.8681 60.8244 33.9282C60.8177 33.9885 60.8114 34.0219 60.8157 34.023C60.819 34.0238 60.8324 33.9922 60.8461 33.9317C60.8591 33.8716 60.8743 33.7807 60.8563 33.6681C60.8391 33.5577 60.7765 33.4202 60.64 33.3406C60.5088 33.2569 60.28 33.2911 60.198 33.4699L60.1897 33.4918L60.2451 33.4966C60.2297 33.3831 60.2101 33.261 60.1318 33.1714C60.0555 33.0857 59.9232 33.05 59.8329 33.1139L59.869 33.125C59.8329 33.0398 59.767 32.9816 59.7026 32.9502C59.6382 32.9172 59.5742 32.909 59.5234 32.9103C59.4722 32.9122 59.4338 32.9252 59.4093 32.9365C59.3853 32.9489 59.374 32.9578 59.3751 32.9595Z" fill="#335863"/>
                    <path d="M62.2543 33.9167C62.256 33.9193 62.2816 33.9096 62.3213 33.8799C62.3597 33.8493 62.4122 33.7972 62.4517 33.7163C62.491 33.6367 62.5178 33.5272 62.4966 33.4074C62.4855 33.3495 62.4669 33.2942 62.4894 33.2491C62.5094 33.202 62.5686 33.1587 62.5912 33.0838C62.635 32.9324 62.5432 32.7754 62.4148 32.7372L62.4287 32.7763C62.5215 32.6309 62.5567 32.4865 62.5671 32.386C62.5773 32.285 62.5669 32.2264 62.5619 32.2266C62.5554 32.2266 62.5547 32.285 62.5361 32.3815C62.5174 32.4771 62.4766 32.6127 62.3853 32.7476L62.3658 32.7765L62.3992 32.7869C62.4977 32.8166 62.5725 32.9496 62.5369 33.0669C62.5228 33.1218 62.4699 33.1602 62.4387 33.2263C62.4068 33.2986 62.4356 33.3671 62.4452 33.4176C62.4669 33.5233 62.4469 33.6239 62.415 33.6996C62.3482 33.8543 62.2467 33.9087 62.2543 33.9167Z" fill="#335863"/>
                    <path d="M63.086 34.1734C63.0866 34.1756 63.1029 34.1738 63.133 34.1664C63.1632 34.1586 63.2068 34.1443 63.2591 34.1179C63.3619 34.066 63.5046 33.9595 63.5944 33.7732L63.559 33.7827C63.6553 33.8528 63.7916 33.8838 63.9278 33.8591C63.9957 33.8461 64.0636 33.8188 64.1236 33.7762C64.1805 33.7316 64.2416 33.6784 64.2575 33.5904C64.262 33.5567 64.2553 33.5283 64.2562 33.5058C64.257 33.4841 64.2629 33.4639 64.2757 33.4455C64.3002 33.4079 64.3429 33.3797 64.385 33.3533C64.4275 33.3283 64.475 33.2967 64.5082 33.2555C64.5427 33.2164 64.5674 33.1546 64.5466 33.0993L64.5193 33.1331C64.6496 33.1459 64.7687 33.1043 64.8533 33.0446C64.9405 32.9861 64.9973 32.9108 65.0316 32.8447C65.0661 32.7776 65.0778 32.7186 65.081 32.6787C65.0832 32.6386 65.0802 32.6171 65.0778 32.6173C65.0687 32.6158 65.0767 32.7061 65.0047 32.8297C64.9685 32.8898 64.9125 32.9577 64.8299 33.0088C64.7496 33.0618 64.6403 33.0954 64.5253 33.0819L64.4846 33.0772L64.498 33.116C64.5095 33.1492 64.4958 33.188 64.467 33.2212C64.4379 33.2552 64.401 33.28 64.3557 33.3062C64.3123 33.3338 64.2637 33.3628 64.2284 33.4145C64.2108 33.4396 64.2002 33.4726 64.1993 33.5047C64.1993 33.5359 64.2043 33.5617 64.2011 33.5826C64.1928 33.64 64.1408 33.6925 64.0907 33.7307C64.038 33.7682 63.9781 33.7932 63.9176 33.8055C63.7955 33.8292 63.6733 33.8036 63.5866 33.7439L63.5629 33.7274L63.551 33.7535C63.4718 33.9296 63.3411 34.0367 63.2456 34.0938C63.1484 34.1515 63.084 34.1671 63.086 34.1734Z" fill="#335863"/>
                    <path d="M67.8528 34.6017L67.8539 34.5811C67.8535 34.5676 67.8517 34.5475 67.8461 34.5219C67.8359 34.4709 67.8118 34.3954 67.7576 34.3132C67.7051 34.2299 67.6236 34.1414 67.5227 34.0503C67.4713 34.0061 67.4205 33.9547 67.3518 33.913C67.3177 33.8931 67.28 33.8748 67.236 33.8677C67.193 33.859 67.1381 33.8701 67.1028 33.9065L67.1433 33.9189C67.1195 33.7896 67.0178 33.6662 66.8733 33.625C66.7291 33.5842 66.556 33.6406 66.4621 33.7751L66.5122 33.7837C66.4913 33.7044 66.43 33.6386 66.3519 33.6094C66.2731 33.5781 66.1779 33.5957 66.1113 33.6482C66.0745 33.6772 66.0445 33.7159 66.0283 33.7603L66.0827 33.7644C66.0721 33.7115 66.0309 33.6723 65.9881 33.653C65.9447 33.6332 65.8962 33.6278 65.8502 33.6373C65.7602 33.6571 65.6942 33.7152 65.6348 33.7647L65.671 33.7653C65.591 33.6931 65.4843 33.666 65.3877 33.6692C65.2901 33.6718 65.198 33.7018 65.121 33.7467C64.9661 33.8373 64.8629 33.9644 64.7702 34.0698L64.806 34.0861C64.811 34.0516 64.7939 34.0137 64.7674 33.9946C64.7416 33.9746 64.7125 33.967 64.6854 33.9629C64.6305 33.9562 64.5787 33.9638 64.534 33.9831C64.4492 34.0221 64.385 34.069 64.3364 34.1115C64.2876 34.1542 64.2553 34.1926 64.2347 34.2195C64.2143 34.2466 64.2059 34.2622 64.2072 34.2631C64.2115 34.2668 64.2523 34.2078 64.3507 34.129C64.4002 34.0904 64.4653 34.0473 64.5466 34.0132C64.5852 33.9976 64.6329 33.9924 64.6798 33.9996C64.7266 34.0061 64.7733 34.0347 64.765 34.0809L64.7529 34.1494L64.8008 34.0972C64.8956 33.9937 64.9997 33.8718 65.1453 33.7898C65.2173 33.749 65.301 33.7234 65.3888 33.7217C65.476 33.72 65.5676 33.7451 65.6339 33.8059L65.6517 33.8219L65.6702 33.8065C65.7294 33.7571 65.7905 33.7072 65.8617 33.6924C65.9276 33.6772 66.0144 33.7119 66.027 33.7757L66.0463 33.874L66.0814 33.7798C66.0938 33.7464 66.1168 33.7161 66.1462 33.6933C66.1998 33.6519 66.2716 33.6386 66.3321 33.6623C66.3931 33.6848 66.4425 33.738 66.4581 33.7978L66.4733 33.8573L66.5083 33.8065C66.5861 33.6929 66.7375 33.6419 66.8594 33.6757C66.9828 33.7093 67.0744 33.8169 67.0961 33.928L67.1052 33.974L67.1368 33.9401C67.1852 33.8889 67.2696 33.9156 67.3299 33.951C67.3923 33.9868 67.445 34.0371 67.4969 34.0796C67.5984 34.167 67.6804 34.2503 67.7346 34.3288C67.8459 34.4859 67.8444 34.6045 67.8528 34.6017Z" fill="#335863"/>
                    <path d="M68.0398 36.2755C68.0416 36.2759 68.0476 36.2614 68.057 36.233C68.0661 36.2046 68.0795 36.1621 68.0893 36.105C68.098 36.0486 68.1055 35.9745 68.0747 35.8933C68.0593 35.8534 68.0342 35.8135 67.9975 35.7805C67.9611 35.7478 67.9097 35.722 67.8516 35.7235L67.8713 35.7495C67.8999 35.6639 67.8808 35.553 67.8034 35.4769C67.7266 35.4012 67.5939 35.3786 67.4867 35.4387L67.5232 35.4697C67.5564 35.3838 67.5175 35.2849 67.4449 35.2298C67.3694 35.1739 67.2694 35.1674 67.1811 35.1891C67.1354 35.1999 67.0959 35.2205 67.0597 35.224C67.0241 35.2288 66.9946 35.2118 66.9651 35.1806C66.9356 35.1518 66.908 35.1092 66.8608 35.0836C66.8167 35.0563 66.7616 35.0453 66.712 35.05C66.6031 35.0587 66.5109 35.1008 66.4198 35.1272C66.3298 35.1552 66.2372 35.168 66.1654 35.1272C66.13 35.1075 66.0994 35.0737 66.0604 35.0448C66.0207 35.0153 65.9728 34.9978 65.9257 34.9921C65.8311 34.9808 65.7361 35.0147 65.675 35.0797L65.7166 35.1043C65.7461 35.0017 65.6839 34.9088 65.6145 34.8622C65.5411 34.8112 65.4531 34.8088 65.3813 34.8203C65.2351 34.8483 65.1262 34.9149 65.0382 34.9678C64.9512 35.0238 64.8896 35.0769 64.8497 35.1151C64.81 35.1535 64.7915 35.1765 64.7931 35.1782C64.7983 35.1841 64.8789 35.0964 65.0535 34.9928C65.141 34.9446 65.2522 34.8826 65.3874 34.8607C65.4537 34.8516 65.5296 34.8568 65.5884 34.8997C65.647 34.9401 65.6925 35.0177 65.6695 35.0893L65.6364 35.1914L65.7112 35.1138C65.7609 35.062 65.8411 35.034 65.9192 35.0444C65.9585 35.0496 65.996 35.0637 66.0283 35.0882C66.0615 35.1127 66.0927 35.1483 66.1378 35.175C66.1838 35.1997 66.2367 35.211 66.2881 35.2092C66.3391 35.2068 66.3881 35.1949 66.4359 35.1812C66.5302 35.1537 66.6224 35.1136 66.7152 35.1069C66.758 35.1029 66.7983 35.1121 66.8317 35.1322C66.8666 35.1498 66.8911 35.186 66.925 35.2201C66.9549 35.2548 67.0111 35.2886 67.0653 35.2797C67.1173 35.2732 67.1562 35.2511 67.1946 35.2428C67.2716 35.2229 67.3553 35.2301 67.4128 35.2726C67.47 35.3142 67.4991 35.3925 67.4761 35.4513L67.4494 35.5194L67.5125 35.4825C67.5965 35.4331 67.7093 35.4496 67.772 35.5101C67.8366 35.5708 67.8555 35.6656 67.8333 35.7374L67.8249 35.7645L67.8531 35.7634C67.947 35.7597 68.0168 35.8372 68.0457 35.9053C68.0758 35.976 68.0728 36.0473 68.0676 36.1022C68.0533 36.2135 68.0346 36.2742 68.0398 36.2755Z" fill="#335863"/>
                    <path d="M69.2891 39.1072C69.2904 39.1087 69.3086 39.0998 69.3373 39.0747C69.3652 39.0495 69.4036 39.007 69.4329 38.9408C69.462 38.8758 69.4817 38.7842 69.4576 38.6836C69.4349 38.5845 69.3694 38.4778 69.2577 38.4123L69.2685 38.4404C69.2997 38.35 69.3392 38.2474 69.3316 38.1285C69.3279 38.0693 69.3067 38.0086 69.2685 37.9581C69.2312 37.9077 69.1713 37.8652 69.1004 37.8607L69.1197 37.9071C69.1965 37.8216 69.211 37.6919 69.1733 37.5835C69.1518 37.5214 69.1154 37.4646 69.0657 37.4223C69.018 37.3787 68.9482 37.3557 68.892 37.3505C68.8334 37.3427 68.8024 37.3254 68.7857 37.2733C68.7681 37.2215 68.7395 37.1661 68.7028 37.1245C68.6291 37.0356 68.5239 36.9967 68.4369 36.9662C68.3482 36.9345 68.2662 36.9039 68.1894 36.8788C68.0365 36.8273 67.9027 36.8089 67.8116 36.8191C67.7658 36.8228 67.7316 36.8326 67.709 36.8399C67.6864 36.8486 67.6752 36.8538 67.6758 36.8558C67.6775 36.8612 67.7246 36.8425 67.8127 36.8412C67.901 36.8382 68.0274 36.8616 68.1762 36.9167C68.2521 36.9458 68.3337 36.977 68.4204 37.0102C68.5078 37.0434 68.5998 37.08 68.6627 37.1581C68.6952 37.1969 68.7171 37.2397 68.7349 37.2928C68.7449 37.3191 68.7601 37.3527 68.7911 37.3737C68.8213 37.3948 68.8542 37.4004 68.8829 37.4056C68.9946 37.4123 69.0826 37.4937 69.1195 37.6017C69.1516 37.6952 69.1384 37.8025 69.0779 37.87L69.0399 37.9125L69.0972 37.9164C69.2011 37.9238 69.2733 38.0355 69.2791 38.1327C69.2874 38.2357 69.2531 38.3344 69.2236 38.425L69.2175 38.4439L69.2345 38.4535C69.334 38.509 69.3967 38.6038 69.4203 38.6929C69.4453 38.7832 69.4312 38.8677 69.4075 38.9304C69.3574 39.058 69.2828 39.102 69.2891 39.1072Z" fill="#335863"/>
                    <path d="M63.0865 36.1405C63.0908 36.1453 63.1492 36.1093 63.2288 36.0293C63.2676 35.9885 63.3119 35.9345 63.3383 35.8599C63.3628 35.7868 63.3698 35.6924 63.3227 35.608L63.2841 35.5575L63.2834 35.5985C63.3476 35.5375 63.3719 35.4523 63.3654 35.3796C63.3591 35.3055 63.3194 35.2471 63.2791 35.2131C63.1943 35.1434 63.1214 35.1554 63.1236 35.1606C63.1212 35.1695 63.1869 35.1738 63.2526 35.241C63.2845 35.274 63.3127 35.3235 63.3145 35.3833C63.3175 35.4421 63.2952 35.5106 63.2451 35.5571L63.2242 35.5761L63.2444 35.5978L63.2735 35.6362C63.3099 35.7002 63.3073 35.7803 63.2884 35.8438C63.2687 35.908 63.2318 35.9612 63.1986 36.0028C63.1301 36.0859 63.08 36.134 63.0865 36.1405Z" fill="#335863"/>
                    <path d="M61.6567 35.9221C61.6647 35.9169 61.5786 35.8707 61.5606 35.7343C61.5532 35.6692 61.5706 35.5833 61.6393 35.5265C61.7048 35.4699 61.8185 35.4439 61.9111 35.4914L61.9547 35.5137L61.9502 35.4649C61.945 35.4068 61.9473 35.3447 61.9656 35.2864C61.9827 35.2291 62.0204 35.1727 62.0731 35.1498C62.1567 35.1127 62.2779 35.1651 62.2749 35.2439L62.3293 35.2393C62.3091 35.122 62.343 35.0066 62.3998 34.9248C62.4568 34.8415 62.5369 34.7925 62.6072 34.7676C62.7516 34.719 62.8468 34.7522 62.8473 34.7424C62.8481 34.7398 62.8264 34.7294 62.7833 34.722C62.7406 34.7151 62.6748 34.712 62.5967 34.7344C62.5195 34.7565 62.428 34.8064 62.3616 34.8973C62.2953 34.9864 62.254 35.1142 62.2753 35.2487L62.3297 35.2441C62.3313 35.1812 62.2844 35.1246 62.2297 35.1016C62.1753 35.0767 62.1105 35.0732 62.0512 35.0973C61.9745 35.132 61.9326 35.2025 61.912 35.2699C61.8916 35.3385 61.8901 35.4068 61.8968 35.4703L61.9359 35.4436C61.8168 35.3864 61.6855 35.4226 61.6094 35.4925C61.5289 35.5642 61.5144 35.6679 61.5279 35.7391C61.5409 35.8128 61.5773 35.8627 61.6057 35.8896C61.635 35.9169 61.6556 35.9241 61.6567 35.9221Z" fill="#335863"/>
                    <path d="M65.9648 38.2994C65.9915 38.2727 67.1086 37.3982 67.5825 38.705C68.0562 40.012 66.6463 40.2181 66.6305 40.1814C66.6147 40.1448 65.9648 38.2994 65.9648 38.2994Z" fill="#D88875"/>
                    <path d="M66.8465 39.5161C66.8506 39.5098 66.8749 39.5237 66.92 39.5274C66.9636 39.531 67.0326 39.5196 67.0915 39.4692C67.2111 39.3686 67.2477 39.1072 67.1688 38.8693C67.1289 38.7493 67.0631 38.645 66.9868 38.5665C66.9122 38.4854 66.8263 38.4409 66.7523 38.4537C66.6773 38.4628 66.6432 38.5222 66.6404 38.565C66.6363 38.6079 66.6541 38.6309 66.648 38.6357C66.6454 38.6402 66.612 38.624 66.6029 38.5661C66.599 38.5381 66.6031 38.5018 66.6246 38.4656C66.6467 38.4288 66.6881 38.399 66.7384 38.3867C66.8417 38.3572 66.966 38.4168 67.0497 38.5032C67.1391 38.5875 67.216 38.7038 67.2607 38.8387C67.3477 39.1053 67.3024 39.4005 67.1332 39.5235C67.0499 39.5809 66.9634 39.5809 66.9124 39.5645C66.8603 39.5469 66.8428 39.5202 66.8465 39.5161Z" fill="#915A53"/>
                    <path d="M63.144 58.2788L63.0859 58.0567L63.144 58.2788Z" fill="#A8ABAB"/>
                    <path d="M63.9569 58.3289C63.4659 58.3289 63.1444 58.2907 63.142 58.2905L63.0839 58.0684L62.9414 57.5237C67.0469 56.8774 71.3964 51.8555 71.3964 51.8555C71.3964 51.8555 69.2281 56.3074 67.4881 57.4541C66.3595 58.1981 64.8666 58.3289 63.9569 58.3289Z" fill="#CC5749"/>
                    <path d="M68.0696 47.5629C66.5865 49.4916 63.7956 53.1331 63.7956 53.1331L53.4648 54.6484L54.0043 58.0724L64.2689 57.4833C65.7813 57.3473 67.1851 56.6417 68.1967 55.5093C69.4517 54.1044 71.1626 52.1562 72.2298 50.8053C73.1922 49.5868 72.8985 47.8045 71.5962 46.959C70.4425 46.2101 68.9077 46.4728 68.0696 47.5629Z" fill="#DE5757"/>
                    <path d="M72.492 82.6063C72.4614 82.6126 71.796 79.5706 71.0056 75.8123C70.2152 72.0528 69.5994 69.0008 69.63 68.9943C69.6604 68.988 70.3258 72.0294 71.1162 75.7889C71.9066 79.5474 72.5226 82.6 72.492 82.6063Z" fill="#335863"/>
                    <path d="M78.6006 80.1291C78.623 80.1506 78.4698 80.3473 78.2583 80.5683C78.0464 80.7896 77.8566 80.9512 77.8343 80.9295C77.8115 80.9078 77.9649 80.7113 78.1766 80.4902C78.388 80.269 78.5781 80.1074 78.6006 80.1291Z" fill="#335863"/>
                    <path d="M69.7463 45.6056C69.7463 45.6056 69.7138 45.6548 69.6446 45.7464C69.5721 45.8409 69.4691 45.9752 69.3361 46.1487C69.06 46.5033 68.6596 47.0181 68.1492 47.674C67.1161 48.9916 65.6393 50.8756 63.85 53.1583L63.8386 53.1726L63.8201 53.1754C60.8603 53.6123 57.3198 54.135 53.4908 54.7005L53.5384 54.6358C53.6403 55.2646 53.749 55.9338 53.8589 56.6101C53.9407 57.1139 54.0218 57.6141 54.1021 58.1076L54.0429 58.0603C58.0931 57.8084 61.8385 57.5757 64.9814 57.3801L64.9766 57.3807C65.6724 57.2328 66.3086 56.9395 66.86 56.5977C67.4122 56.2507 67.8786 55.8388 68.257 55.3985C69.0208 54.5194 69.6847 53.755 70.2317 53.1249C70.777 52.5007 71.2056 52.0105 71.5008 51.6723C71.6457 51.5088 71.7578 51.3823 71.837 51.2932C71.9133 51.2077 71.9556 51.1663 71.9556 51.1663C71.9556 51.1663 71.9209 51.2142 71.8478 51.3023C71.7711 51.3936 71.6624 51.5231 71.5223 51.6905C71.2312 52.0324 70.8093 52.5284 70.2721 53.1598C69.7294 53.7938 69.0709 54.5634 68.3137 55.4483C67.5582 56.3376 66.4203 57.1436 64.992 57.4725L64.9907 57.4727L64.9873 57.4729C61.8448 57.6742 58.0996 57.9136 54.05 58.1728L53.999 58.1759L53.9908 58.1256C53.9108 57.6321 53.8294 57.1321 53.7477 56.6283C53.6379 55.9518 53.5292 55.2826 53.4271 54.6538L53.418 54.5974L53.4746 54.5892C57.3044 54.0309 60.846 53.5149 63.8067 53.0835L63.777 53.1006C65.579 50.8284 67.0669 48.9526 68.1074 47.641C68.6262 46.9918 69.0333 46.4825 69.314 46.1314C69.4517 45.9615 69.5582 45.8301 69.6335 45.7375C69.7062 45.649 69.7463 45.6056 69.7463 45.6056Z" fill="#0C2B34"/>
                    <path d="M71.0209 57.2758C71.0274 57.2801 70.9816 57.3606 70.8929 57.5025C70.8057 57.6454 70.6669 57.8445 70.4849 58.0827C70.1223 58.559 69.5618 59.1769 68.8482 59.7528C68.1335 60.3274 67.4102 60.7432 66.8673 60.9961C66.5959 61.1232 66.3719 61.216 66.2135 61.2709C66.0558 61.3273 65.9676 61.3548 65.965 61.3477C65.9576 61.3292 66.302 61.1948 66.8321 60.9245C67.3618 60.6549 68.0702 60.233 68.7775 59.665C69.4831 59.0952 70.0466 58.4933 70.4225 58.033C70.7999 57.5727 71.0044 57.2647 71.0209 57.2758Z" fill="#0C2B34"/>
                    <path d="M71.985 58.8389C72.0002 58.866 71.0814 59.4174 69.9327 60.0703C68.7835 60.7236 67.84 61.2309 67.8244 61.2036C67.809 61.1765 68.728 60.6253 69.8769 59.9722C71.0256 59.3194 71.9696 58.8118 71.985 58.8389Z" fill="#0C2B34"/>
                    <path d="M61.6395 52.7155C61.631 52.7145 61.6111 52.6388 61.5673 52.4967C61.5189 52.3305 61.4601 52.1301 61.3918 51.895C61.2411 51.3586 61.0474 50.668 60.8331 49.9045C60.619 49.1256 60.4299 48.4192 60.2984 47.9064C60.2394 47.6687 60.1893 47.4657 60.1477 47.2978C60.1147 47.1533 60.1 47.0724 60.1073 47.0705C60.1149 47.0683 60.144 47.1451 60.1902 47.2859C60.2362 47.4268 60.2995 47.6314 60.3752 47.8852C60.5264 48.3923 60.7279 49.0955 60.942 49.8744C61.156 50.6533 61.3421 51.3603 61.4688 51.8746C61.5966 52.3874 61.6601 52.7132 61.6395 52.7155Z" fill="#0C2B34"/>
                    <path d="M66.9922 62.0367C68.8042 61.3513 70.5565 60.5089 72.2234 59.5215C71.8171 60.4607 70.9446 61.1364 69.9958 61.5199C69.0469 61.9031 68.0101 61.9296 66.9922 62.0367Z" fill="#CC5749"/>
                    <path d="M48.9997 59.0991C48.978 59.1227 48.7882 59.308 48.6104 59.4811C48.4021 59.6832 48.2527 59.9318 48.1803 60.1958C48.0963 60.5014 48.0406 60.741 48.0276 60.7588L47.6055 62.1027L49.1669 63.2469L49.4172 62.1179C49.4172 62.1179 50.0668 61.8602 50.4122 61.5286C50.7575 61.1967 50.9134 61.0467 51.0019 60.7601C51.0587 60.5745 50.9587 60.4387 50.9587 60.4387C50.9587 60.4387 50.9386 59.822 50.716 59.8034C50.716 59.8034 50.8401 59.4808 50.7598 59.3084C50.6163 58.9989 50.1831 59.0228 50.1831 59.0228C50.1831 59.0228 50.3323 58.8922 50.169 58.78C50.0055 58.6679 49.8853 58.8291 49.8853 58.8291L49.0125 59.6047L48.9997 59.0991Z" fill="#F9B299"/>
                    <path d="M36.4591 63.0023C35.8192 64.0091 36.0099 65.332 36.9089 66.1159C38.9682 67.912 44.5436 71.0363 45.3804 70.897C46.5896 70.6964 49.7507 63.6573 49.7507 63.6573L47.3991 61.7189L44.4564 66.4877C44.4564 66.4877 42.0286 64.1959 40.1301 62.6923C38.9758 61.7781 37.2488 61.7592 36.4591 63.0023Z" fill="#DE5757"/>
                    <path d="M40.021 62.6264C40.0223 62.6247 40.0505 62.6468 40.1041 62.6909C40.1616 62.7394 40.2396 62.805 40.3396 62.8891C40.5496 63.0696 40.8504 63.3281 41.2348 63.6585C42.0119 64.3337 43.1253 65.3011 44.4905 66.4873L44.425 66.4968C45.2655 65.1288 46.2647 63.5027 47.3583 61.7226L47.3909 61.6699L47.4386 61.7094C48.1932 62.3304 48.9808 62.9785 49.7917 63.6459L49.8247 63.6732L49.8071 63.7123C49.5573 64.2643 49.2842 64.8432 49.0005 65.4269C48.5027 66.4487 47.9967 67.4373 47.4661 68.37C47.2006 68.8359 46.9291 69.2881 46.6404 69.7174C46.4938 69.9308 46.3469 70.141 46.1847 70.3371C46.0218 70.5318 45.8565 70.7251 45.6426 70.87C45.5372 70.9387 45.4019 70.9988 45.267 70.9813C45.1379 70.9702 45.0201 70.9357 44.9035 70.9014C44.6711 70.8294 44.4503 70.7409 44.2343 70.6503C43.8044 70.4657 43.3966 70.2666 43.0062 70.0674C42.2258 69.6681 41.5152 69.2662 40.8736 68.8877C39.5913 68.1297 38.5897 67.4562 37.9188 66.9621C37.5835 66.7148 37.3301 66.5135 37.1629 66.3715C37.0783 66.3016 37.0171 66.2444 36.9751 66.2073C36.9334 66.1693 36.9128 66.1494 36.9141 66.1478C36.9154 66.1465 36.9386 66.1637 36.9827 66.1984C37.0308 66.237 37.0952 66.2884 37.1772 66.3539C37.3488 66.4901 37.606 66.6851 37.9446 66.9265C38.622 67.4087 39.6286 68.0709 40.9142 68.819C41.5571 69.1925 42.2688 69.5894 43.0487 69.9839C43.4387 70.1805 43.8458 70.3772 44.2731 70.5587C44.4872 70.6481 44.7065 70.7349 44.9327 70.8038C45.0455 70.8368 45.1616 70.8696 45.275 70.8787C45.3856 70.8923 45.4863 70.8461 45.5854 70.7832C45.7802 70.6511 45.9444 70.4609 46.1025 70.2698C46.261 70.0774 46.4061 69.8688 46.551 69.6573C46.8363 69.2306 47.1059 68.7799 47.37 68.3153C47.8973 67.385 48.4018 66.3979 48.899 65.3776C49.182 64.7946 49.4553 64.2161 49.705 63.6663L49.7204 63.7326C48.9105 63.0639 48.1238 62.4147 47.37 61.7925L47.4501 61.7792C46.3495 63.555 45.3444 65.1774 44.4985 66.5424L44.4714 66.586L44.433 66.5519C43.0784 65.3538 41.974 64.3768 41.2029 63.6951C40.8253 63.3572 40.5294 63.0926 40.3232 62.9082C40.2266 62.8201 40.1512 62.7512 40.0956 62.7006C40.0449 62.6531 40.0195 62.6282 40.021 62.6264Z" fill="#0C2B34"/>
                    <path d="M37.2995 24.4061C37.3008 24.4272 37.2591 24.5072 37.198 24.612C36.9368 25.0601 36.9514 25.618 37.2348 26.0522L37.7283 26.8077L37.7884 27.9694L40.309 28.5741L40.1906 26.5257C40.1906 26.5257 40.6072 25.662 40.612 25.0777C40.6165 24.4933 40.4612 23.8723 40.2697 23.8461C40.0784 23.8201 40.0196 23.812 40.0196 23.812C40.0196 23.812 39.8262 23.4706 39.5188 23.4136C39.5188 23.4136 39.367 22.6581 39.1058 22.5924C38.8449 22.5269 38.6133 22.7952 38.6133 22.7952C38.6133 22.7952 38.2916 22.1786 38.017 22.2189C37.4578 22.3015 37.4576 22.8635 37.4576 22.8635L37.2915 24.4599L37.2995 24.4061Z" fill="#FCCBB6"/>
                    <path d="M31.425 0.545912C31.3196 0.209064 30.9608 0.021662 30.624 0.127076C30.2871 0.232707 30.0997 0.591244 30.2051 0.928092L60.6006 97.7605L61.9317 97.8158L31.425 0.545912Z" fill="#D7D9D9"/>
                    <path d="M32.1949 1.80676C32.1949 1.80676 24.1166 7.31367 17.8674 7.81102C11.6183 8.30816 4.54885 8.78469 0.832031 12.9572C0.832031 12.9572 14.5632 15.1121 15.3373 16.9371C15.3373 16.9371 7.12932 23.457 5.88518 27.1998C5.88518 27.1998 11.791 25.1074 13.0089 24.5914C17.056 22.8768 24.9258 23.6409 27.9223 22.5594C31.2429 21.3613 34.3845 17.9928 37.1166 17.4685L32.1949 1.80676Z" fill="#DE5757"/>
                    <path d="M22.9594 19.2072L22.403 15.6301L19.1406 14.0604L22.3712 12.4258L22.8559 8.83803L25.4086 11.4053L28.9706 10.7576L27.318 13.9788L29.0346 17.1662L25.4605 16.5899L22.9594 19.2072Z" fill="#F6948E"/>
                    <path d="M29.7243 7.47073C29.728 7.47203 29.7115 7.523 29.6766 7.61844C29.6367 7.72407 29.5844 7.86224 29.5191 8.03424C29.4512 8.21513 29.3641 8.43485 29.25 8.68451C29.1376 8.93481 29.0183 9.22416 28.86 9.53129C28.7084 9.84189 28.5405 10.1811 28.3401 10.5347C28.1509 10.8947 27.9219 11.2639 27.6863 11.6556C27.1983 12.4282 26.6226 13.254 25.9598 14.0752C25.2909 14.8918 24.6 15.624 23.9428 16.2596C23.6075 16.5702 23.2928 16.8697 22.9789 17.1283C22.6735 17.3968 22.3759 17.6304 22.1024 17.8421C21.8341 18.0596 21.5751 18.2355 21.353 18.3967C21.132 18.5592 20.9348 18.6893 20.7715 18.7928C20.6164 18.8917 20.4919 18.971 20.3967 19.0318C20.3102 19.0854 20.264 19.1118 20.2618 19.1086C20.2596 19.1053 20.3019 19.0723 20.3841 19.0127C20.4763 18.9476 20.5967 18.8624 20.7468 18.7563C20.906 18.6476 21.099 18.5125 21.3162 18.3455C21.5339 18.18 21.7888 18.0002 22.0532 17.7792C22.3226 17.5644 22.6163 17.3278 22.9178 17.0573C23.2277 16.7968 23.5387 16.4958 23.8708 16.1845C24.5209 15.5475 25.2063 14.8167 25.8722 14.0038C26.5318 13.1865 27.1074 12.3666 27.598 11.6003C27.8351 11.2118 28.0663 10.8459 28.2581 10.4893C28.4611 10.139 28.6327 9.80307 28.7884 9.49572C28.9509 9.19184 29.0747 8.90575 29.1923 8.6587C29.3116 8.41208 29.4044 8.1954 29.4786 8.01754C29.5517 7.84879 29.6105 7.71366 29.6556 7.6102C29.6972 7.51736 29.7206 7.46943 29.7243 7.47073Z" fill="#0C2B34"/>
                    <path d="M34.2872 15.8594C34.2835 15.8605 34.2671 15.8198 34.2393 15.7415C34.2089 15.651 34.1705 15.5369 34.1235 15.3968C34.023 15.0814 33.8855 14.6498 33.7179 14.1232C33.3808 13.0458 32.9234 11.5553 32.429 9.90552C31.9347 8.25533 31.4977 6.75828 31.1947 5.67074C31.0435 5.12697 30.9255 4.68536 30.8511 4.37844C30.8138 4.22488 30.7871 4.10493 30.773 4.02273C30.7658 3.98151 30.7617 3.94985 30.7617 3.92772L30.7745 3.90625L30.778 3.91471C30.7619 3.89302 30.7752 3.9364 30.7951 4.01774C30.8209 4.10949 30.8535 4.22509 30.8934 4.36716C30.9871 4.68449 31.115 5.11851 31.2717 5.64862C31.5994 6.74288 32.0449 8.22974 32.5373 9.8732C33.0262 11.5171 33.4686 13.0048 33.7944 14.0999C33.9478 14.6309 34.0736 15.066 34.1655 15.384C34.2044 15.5265 34.236 15.6428 34.2612 15.7347C34.2818 15.8154 34.2909 15.8581 34.2872 15.8594Z" fill="#0C2B34"/>
                    <path d="M34.7559 17.2124C33.3838 15.7772 32.5654 13.8852 32.1223 11.9495C31.7275 10.2265 31.6108 8.45525 31.5256 6.68773C31.7913 7.61259 32.113 8.70599 32.4637 9.87661C32.7342 10.7791 32.9936 11.6342 33.2283 12.3998C33.7089 14.0129 34.2182 15.6173 34.7559 17.2124ZM31.821 7.33756C31.71 6.96688 31.6048 6.61615 31.5069 6.2895C31.5033 6.21141 31.4998 6.13289 31.4961 6.05481C31.6024 6.48276 31.7106 6.9107 31.821 7.33756Z" fill="#CC5749"/>
                    <path d="M33.2174 12.4093C32.9827 11.6436 32.7233 10.7886 32.4528 9.88606C32.1021 8.71545 31.7805 7.62205 31.5147 6.69718C31.5085 6.56422 31.5022 6.43169 31.4961 6.29895C31.5939 6.6256 31.6991 6.97633 31.8102 7.34702C32.2479 9.04297 32.7172 10.7307 33.2174 12.4093Z" fill="#011721"/>
                    <path d="M31.4962 6.07998C31.4961 6.07155 31.4961 6.06312 31.4961 6.05469L31.4961 6.05868C31.4962 6.06578 31.4962 6.07288 31.4962 6.07998Z" fill="#CC5749"/>
                    <path d="M48.0777 53.6622C48.1376 53.6672 49.1104 53.6653 49.6888 53.6635C49.963 53.6629 50.2263 53.7627 50.4304 53.9457C50.8831 54.352 51.6574 55.0497 51.6574 55.0497L53.4486 54.8448L53.9464 57.8059L51.4672 57.7124C51.4672 57.7124 50.4048 58.0189 49.7452 58.0094C49.0856 57.9998 48.3885 57.8089 48.3638 57.5923C48.3393 57.3756 48.3317 57.3088 48.3317 57.3088C48.3317 57.3088 47.9513 57.0821 47.8949 56.734C47.8949 56.734 47.0459 56.5433 46.9785 56.247C46.911 55.9508 47.2199 55.6963 47.2199 55.6963C47.2199 55.6963 46.5353 55.3181 46.5846 55.0085C46.6338 54.699 46.9327 54.5301 46.9327 54.5301L48.276 54.35L48.0777 53.6622Z" fill="#D88875"/>
                    <path d="M44.1133 52.4902C44.6994 53.2798 44.8616 54.3662 44.5313 55.2926C44.371 55.7424 44.1018 56.2329 44.3057 56.6649C44.5074 57.0924 45.0913 57.2401 45.2781 57.6746C45.4978 58.1863 45.0482 58.7366 45.0256 59.2927C45.0043 59.8148 45.4247 60.318 45.9424 60.39C45.2258 60.7097 44.4202 60.8268 43.6422 60.7244C43.5171 60.426 43.3919 60.1275 43.267 59.8291C43.4149 60.1471 43.2451 60.5438 42.9618 60.7507C42.6787 60.9578 42.3135 61.0134 41.963 61.0281C40.2887 61.0988 38.5997 60.3321 37.5508 59.0252" fill="#0C2B34"/>
                    <path d="M34.3879 54.2168C34.5985 53.8956 34.8804 53.6216 35.0564 53.28C35.4342 52.546 35.2928 51.5658 35.8611 50.9672C36.2656 50.5407 36.9052 50.452 37.4926 50.4321C38.0797 50.4123 38.7001 50.4286 39.2122 50.1406C39.5878 49.9291 39.8655 49.5729 40.2405 49.3604C40.7747 49.0576 41.4347 49.0847 42.036 49.209C42.6537 49.3365 43.266 49.5656 43.7397 49.982C44.2135 50.3982 44.5306 51.0249 44.4648 51.6524C44.433 51.9582 44.3135 52.2554 44.3295 52.5625C44.3466 52.9002 44.5249 53.2078 44.5965 53.5381C44.7477 54.2365 44.3518 55.0145 43.6983 55.3035L38.065 59.5593C37.0991 59.6525 35.0846 58.6761 34.5829 57.8451C34.0814 57.0142 33.8554 55.0282 34.3879 54.2168Z" fill="#0C2B34"/>
                    <path d="M43.7901 54.5876C43.9502 53.3176 43.4123 51.6197 42.1367 51.5137L38.0444 51.7566C37.657 51.7245 37.3093 51.9941 37.2441 52.3774L35.868 61.8716L35.8398 61.8722C35.8398 61.8722 36.217 64.6978 38.9524 64.3844C39.4948 64.3221 39.6755 64.5523 39.8878 63.9963C39.9019 63.9282 39.8885 63.9933 39.9019 63.9282C40.069 63.2268 40.3796 61.7746 40.3796 61.7746C40.5333 61.0161 40.5926 60.7046 40.5917 60.7116C40.5917 60.7116 42.2456 60.7511 42.9763 58.7226C43.3396 57.714 43.6122 55.9985 43.7901 54.5876Z" fill="#F9B299"/>
                    <path d="M40.2898 55.8149C40.2678 55.9578 40.1288 56.0567 39.9796 56.0363C39.8306 56.0164 39.7271 55.8845 39.749 55.742C39.7711 55.5993 39.9102 55.5001 40.0592 55.5203C40.2084 55.5405 40.3119 55.6724 40.2898 55.8149Z" fill="#0C2B34"/>
                    <path d="M43.0242 56.2544C43.0021 56.3969 42.8632 56.4958 42.7138 56.4761C42.5648 56.4555 42.4613 56.3238 42.4834 56.1811C42.5054 56.0386 42.6444 55.9395 42.7934 55.9596C42.9428 55.9798 43.0461 56.1117 43.0242 56.2544Z" fill="#0C2B34"/>
                    <path d="M43.3536 55.4197C43.3119 55.4603 43.1094 55.2393 42.7912 55.2007C42.4741 55.1571 42.2197 55.3189 42.1902 55.2692C42.1754 55.2469 42.2218 55.1705 42.3329 55.0968C42.4422 55.0232 42.6222 54.961 42.8202 54.9864C43.018 55.0122 43.1753 55.118 43.2614 55.2169C43.3497 55.3165 43.3737 55.402 43.3536 55.4197Z" fill="#0C2B34"/>
                    <path d="M40.4266 55.0005C40.3784 55.0349 40.1852 54.7953 39.8522 54.7198C39.5206 54.6395 39.2354 54.7673 39.2089 54.7155C39.1957 54.6918 39.2517 54.6226 39.377 54.5638C39.5002 54.5051 39.6965 54.4656 39.9038 54.5139C40.111 54.5628 40.2671 54.6847 40.3487 54.7914C40.4322 54.8992 40.4496 54.9855 40.4266 55.0005Z" fill="#0C2B34"/>
                    <path d="M41.0156 57.2155C41.0174 57.1988 41.2026 57.202 41.5004 57.2203C41.5757 57.2266 41.6481 57.2253 41.6702 57.1775C41.6978 57.1274 41.682 57.0422 41.6627 56.9496C41.6273 56.758 41.5904 56.5572 41.5516 56.3466C41.4011 55.4898 41.3072 54.7912 41.3419 54.7853C41.3763 54.7797 41.5264 55.4694 41.6768 56.3262C41.7121 56.537 41.7459 56.7383 41.778 56.9307C41.79 57.0196 41.8199 57.1237 41.7611 57.2272C41.7308 57.2784 41.6692 57.3081 41.6193 57.312C41.5694 57.3172 41.5277 57.3103 41.4909 57.3053C41.1952 57.2654 41.0135 57.232 41.0156 57.2155Z" fill="#0C2B34"/>
                    <path d="M40.6001 60.7046C40.6001 60.7046 39.1758 60.5274 37.9414 59.4238C37.9414 59.4238 38.3472 60.9901 40.4778 61.1933L40.6001 60.7046Z" fill="#F79570"/>
                    <path d="M40.7952 57.901C40.7174 57.744 40.5499 57.6338 40.3656 57.619C40.2378 57.6086 40.0999 57.6449 40.0042 57.7325C39.9088 57.8199 39.8652 57.9617 39.9159 58.0722C39.9727 58.1964 40.1307 58.2528 40.276 58.2398C40.4213 58.227 40.5571 58.1589 40.6868 58.0899C40.7228 58.0711 40.7597 58.0509 40.7855 58.0205C40.8115 57.99 40.8243 57.9459 40.8057 57.913" fill="#DE5757"/>
                    <path d="M40.1258 57.2758C40.1733 57.2821 40.1141 57.5955 40.3398 57.869C40.565 58.1432 40.9057 58.1716 40.8999 58.2158C40.9005 58.2364 40.8138 58.2625 40.6721 58.2395C40.5329 58.218 40.3396 58.1349 40.2013 57.9677C40.0637 57.8 40.028 57.6048 40.0418 57.474C40.0549 57.3409 40.1047 57.2699 40.1258 57.2758Z" fill="#0C2B34"/>
                    <path d="M40.651 54.0064C40.6075 54.0795 40.3264 53.9873 39.98 53.9635C39.634 53.9329 39.3421 53.9799 39.3104 53.901C39.297 53.8635 39.3586 53.7988 39.4835 53.7437C39.6073 53.6889 39.7958 53.6498 40.0034 53.6659C40.211 53.6824 40.3908 53.7502 40.5046 53.824C40.6196 53.8977 40.6704 53.9713 40.651 54.0064Z" fill="#0C2B34"/>
                    <path d="M43.3017 54.5275C43.2312 54.5819 43.0169 54.4704 42.7443 54.4153C42.4734 54.3518 42.2311 54.363 42.1908 54.2845C42.1738 54.2466 42.2229 54.188 42.3359 54.1451C42.4473 54.1023 42.6235 54.0835 42.8104 54.1242C42.9972 54.1652 43.1486 54.2557 43.2308 54.3409C43.3145 54.4266 43.3334 54.5003 43.3017 54.5275Z" fill="#0C2B34"/>
                    <path d="M37.1309 51.8061C37.399 51.5665 37.7799 51.5088 38.1378 51.4717C39.681 51.3114 41.2436 51.3357 42.7814 51.5441C42.8835 51.8992 42.5998 52.2677 42.2606 52.4139C41.9214 52.5601 41.539 52.5503 41.1713 52.5846C40.8035 52.6189 40.4087 52.7184 40.182 53.0099C39.9408 53.3203 39.9519 53.768 39.7265 54.0899C39.3387 54.6434 38.4284 54.6089 38.0441 55.1651C37.7532 55.5854 37.8883 56.1539 37.823 56.6608C37.7491 57.2356 37.3849 57.7653 36.8752 58.0405C36.473 58.2576 35.9891 58.3093 35.5469 58.198C35.9232 56.4092 36.2995 54.6204 36.6756 52.8316C36.7541 52.4592 36.8472 52.0601 37.1309 51.8061Z" fill="#0C2B34"/>
                    <path d="M32.3422 55.3119C32.6879 55.1379 33.0953 55.0169 33.3029 54.6905C33.6054 54.2148 33.3538 53.491 33.7508 53.0906C34.113 52.7258 34.8292 52.9436 35.1764 52.5646C35.4478 52.2683 35.3263 51.9083 35.476 51.6244C35.6254 51.3404 36.1267 51.1914 36.4247 51.3112L37.8838 55.4498C37.7899 56.6799 37.8456 57.3636 37.409 57.9793C37.1693 58.3173 36.8904 58.6342 36.729 59.0157C36.5676 59.397 36.547 59.8733 36.8073 60.1954C35.3387 59.9178 34.1952 58.7994 33.1473 57.7338C32.7775 57.3577 32.4079 56.9818 32.0381 56.6057C31.9227 56.4884 31.803 56.3641 31.7579 56.2057C31.6516 55.8338 31.9965 55.4854 32.3422 55.3119Z" fill="#0C2B34"/>
                    <path d="M33.2539 57.3292C33.2539 57.3292 33.2999 57.3622 33.3994 57.4004C33.4986 57.4383 33.6521 57.4847 33.856 57.4902C34.058 57.4954 34.3143 57.4609 34.5722 57.3234C34.8293 57.1887 35.0754 56.9366 35.2114 56.5944C35.2789 56.4237 35.3184 56.2315 35.3142 56.03C35.3097 55.8276 35.2526 55.625 35.1921 55.4231C35.1331 55.2209 35.0652 55.0118 35.067 54.7936C35.0685 54.5796 35.1327 54.3416 35.3097 54.2048C35.488 54.0651 35.7426 54.0881 35.9927 54.0586C36.1185 54.0438 36.2549 54.0052 36.361 53.9145C36.4671 53.8241 36.5298 53.6944 36.5623 53.5643C36.6306 53.3001 36.5838 53.0289 36.602 52.7708C36.6107 52.6413 36.6363 52.5123 36.6994 52.403C36.7616 52.2936 36.864 52.2108 36.9861 52.1676C37.2338 52.0757 37.5054 52.124 37.7663 52.1707C38.0279 52.2219 38.3116 52.2368 38.5667 52.1537C38.8224 52.0778 39.0508 51.9316 39.2232 51.7414C39.3952 51.5484 39.5007 51.3198 39.5974 51.1031C39.6939 50.8857 39.7846 50.6734 39.9138 50.4949C40.0427 50.3172 40.2106 50.1782 40.3904 50.0769C40.7554 49.8795 41.1615 49.832 41.5076 49.8962C41.8562 49.96 42.1412 50.1344 42.3479 50.3235C42.557 50.5138 42.696 50.7192 42.7874 50.8957C42.9687 51.2534 42.9839 51.4833 42.9967 51.4794C42.998 51.4792 42.9969 51.4651 42.993 51.4382C42.9882 51.4115 42.9847 51.371 42.9719 51.3193C42.95 51.2152 42.9053 51.0634 42.8175 50.8805C42.7294 50.6988 42.5919 50.4862 42.3809 50.288C42.1718 50.0906 41.8809 49.9062 41.5189 49.8359C41.1604 49.7657 40.7389 49.8103 40.3559 50.0136C40.1672 50.1181 39.9893 50.2632 39.852 50.45C39.7154 50.637 39.6215 50.8545 39.5243 51.0703C39.4273 51.2857 39.3234 51.5061 39.1616 51.6859C38.999 51.8638 38.7834 52.0013 38.5424 52.0722C38.3005 52.1494 38.042 52.1362 37.7808 52.0856C37.5225 52.0399 37.2332 51.9841 36.9558 52.0863C36.8191 52.134 36.6959 52.2327 36.6243 52.3596C36.5515 52.4865 36.525 52.629 36.5159 52.7648C36.4983 53.0385 36.5432 53.3009 36.4799 53.5439C36.4499 53.6632 36.3948 53.7749 36.3064 53.8508C36.2176 53.9267 36.1016 53.9618 35.9819 53.9764C35.8621 53.9924 35.7383 53.9922 35.614 54.0093C35.4912 54.0247 35.362 54.0612 35.2609 54.1414C35.0551 54.3041 34.9915 54.5659 34.9906 54.7932C34.9906 55.0286 35.0631 55.2426 35.1232 55.4437C35.1854 55.6454 35.2414 55.8406 35.2472 56.0319C35.2529 56.2235 35.2171 56.4078 35.1544 56.572C35.0273 56.9019 34.7943 57.1472 34.5488 57.2809C34.3024 57.4175 34.0541 57.4565 33.8565 57.4565C33.4548 57.4498 33.2569 57.3138 33.2539 57.3292Z" fill="#335863"/>
                    <path d="M31.9679 54.3713C31.9679 54.3713 31.9295 54.3989 31.8888 54.4763C31.8478 54.552 31.8139 54.6861 31.8536 54.8496C31.8751 54.9298 31.9144 55.0177 31.9853 55.093C32.0554 55.1676 32.154 55.2287 32.2701 55.258C32.4985 55.3227 32.8056 55.258 33.0086 55.0292C33.1101 54.9181 33.1871 54.7765 33.2301 54.6186C33.2728 54.4598 33.2756 54.2876 33.2578 54.1158C33.2281 53.7738 33.1034 53.4141 33.1976 53.0493C33.2414 52.8719 33.3346 52.6916 33.4986 52.6001C33.6619 52.5051 33.8686 52.5272 34.0656 52.5789C34.2645 52.6257 34.4725 52.709 34.7059 52.6832C34.8206 52.6693 34.9347 52.6181 35.0204 52.537C35.1069 52.4567 35.1683 52.355 35.2117 52.2483C35.2989 52.0312 35.3041 51.8047 35.3332 51.5948C35.3566 51.3833 35.4234 51.1866 35.5273 51.0111C35.7355 50.6617 36.0752 50.4129 36.435 50.3144C36.7977 50.2112 37.1638 50.2888 37.4939 50.3576C37.8258 50.4289 38.1472 50.4942 38.4433 50.461C38.7376 50.4337 38.9931 50.3413 39.1977 50.2305C39.404 50.1207 39.559 49.9895 39.6736 49.873C39.9017 49.6357 39.9688 49.4631 39.9688 49.4631C39.9597 49.4566 39.8811 49.6236 39.6499 49.8489C39.5337 49.9598 39.3786 50.0845 39.1749 50.1875C38.9732 50.2918 38.7231 50.3773 38.4381 50.3999C38.1526 50.4281 37.8414 50.3619 37.5091 50.2871C37.1796 50.2159 36.8014 50.1302 36.414 50.2374C36.0333 50.3393 35.6756 50.5988 35.4542 50.9677C35.344 51.1512 35.2718 51.3655 35.2477 51.5833C35.2182 51.7987 35.2113 52.0188 35.131 52.2158C35.0555 52.4127 34.8985 52.5776 34.6948 52.5975C34.4933 52.6218 34.2899 52.5452 34.0862 52.4962C33.886 52.4444 33.6504 52.4153 33.4576 52.5281C33.2652 52.6378 33.1659 52.8407 33.1197 53.0302C33.0715 53.223 33.0789 53.4211 33.106 53.6018C33.1316 53.7837 33.1683 53.9557 33.1863 54.1232C33.2051 54.29 33.2034 54.4531 33.1652 54.6015C33.1266 54.7498 33.0561 54.8834 32.9631 54.9878C32.7776 55.2027 32.4965 55.2663 32.282 55.2112C32.1738 55.1858 32.0814 55.1314 32.015 55.0643C31.9482 54.9969 31.9089 54.9155 31.8862 54.8407C31.8439 54.6876 31.8701 54.5589 31.9044 54.4837C31.9387 54.4069 31.9718 54.3746 31.9679 54.3713Z" fill="#0C2B34"/>
                    <path d="M46.9135 59.3113C46.9005 59.3069 46.9541 59.4705 46.8068 59.6863C46.7348 59.7869 46.6042 59.898 46.4257 59.9082C46.2515 59.9195 46.0411 59.8171 45.9368 59.6208C45.8843 59.5241 45.8709 59.4052 45.895 59.2859C45.919 59.1668 45.9759 59.0493 46.0487 58.9369C46.1912 58.7141 46.419 58.4914 46.4812 58.1678C46.5474 57.855 46.4767 57.4978 46.2693 57.2177C46.1672 57.0774 46.0359 56.9557 45.8852 56.8603C45.7344 56.762 45.5616 56.7026 45.3928 56.6475C45.2236 56.592 45.056 56.5417 44.9098 56.4605C44.764 56.3809 44.6443 56.2629 44.5881 56.1152C44.5315 55.9675 44.5335 55.804 44.5636 55.6515C44.5938 55.4975 44.6523 55.3541 44.7213 55.2179C44.8582 54.9466 45.02 54.6908 45.0785 54.4115C45.1384 54.1347 45.1002 53.8638 45.0113 53.643C44.9228 53.4187 44.7738 53.2558 44.6502 53.12C44.5241 52.9838 44.417 52.8667 44.3456 52.7596C44.1975 52.545 44.2042 52.3889 44.1921 52.3928L44.1914 52.4197C44.1934 52.4372 44.1923 52.4643 44.2009 52.498C44.2127 52.5665 44.2465 52.6661 44.3172 52.7778C44.3862 52.891 44.4918 53.0135 44.6139 53.1524C44.7345 53.2916 44.8738 53.4515 44.954 53.6658C45.0354 53.8775 45.0677 54.1356 45.0083 54.3961C44.9506 54.6583 44.792 54.9062 44.6499 55.1819C44.5788 55.3201 44.5152 55.4719 44.4823 55.6354C44.4495 55.7975 44.4447 55.9771 44.5087 56.1456C44.5721 56.3152 44.7105 56.4503 44.8677 56.536C45.0256 56.6236 45.1976 56.6746 45.3659 56.7304C45.5347 56.7855 45.6978 56.8416 45.839 56.9332C45.9811 57.023 46.1047 57.137 46.2006 57.2678C46.3953 57.5286 46.4622 57.8606 46.4029 58.1517C46.3496 58.4487 46.1364 58.6636 45.9882 58.8981C45.9136 59.0161 45.8537 59.1419 45.8292 59.2735C45.8039 59.4041 45.8214 59.5416 45.8828 59.6496C46.0036 59.8674 46.2355 59.973 46.429 59.9565C46.6274 59.9398 46.7628 59.8147 46.8346 59.7054C46.9092 59.5926 46.9263 59.4852 46.9281 59.4165C46.9276 59.346 46.9135 59.3113 46.9135 59.3113Z" fill="#0C2B34"/>
                    <path d="M18.7038 91.3261L22.9256 90.4298L23.6286 93.8911L20.5256 93.9601L20.5566 96.7586C21.9495 97.1514 22.1447 97.8559 22.1447 97.8559L19.2328 97.7895L16.6992 92.6374L18.7038 91.3261Z" fill="#DE5757"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M16.6992 92.6619L16.8211 92.5821L16.6992 92.6619ZM16.9372 92.5062L17.1257 92.3828L16.9372 92.5062Z" fill="#F4F5F4"/>
                    <path d="M16.7969 92.5565L16.9129 92.4806L16.7969 92.5565Z" fill="#EEEEEE"/>
                    <path d="M22.1447 97.8802L19.2328 97.8138L16.6992 92.6617L16.8211 92.5819L16.9372 92.506L17.1256 92.3828L19.4617 97.2509L21.8265 97.4351L22.1447 97.8802Z" fill="#F9BAB8"/>
                    <path d="M20.5573 95.5093C20.5349 95.5385 20.3692 95.4394 20.1439 95.4407C19.9185 95.4357 19.7513 95.532 19.7294 95.5023C19.7025 95.4798 19.8706 95.3091 20.145 95.3125C20.4193 95.3136 20.5844 95.4871 20.5573 95.5093Z" fill="#0C2B34"/>
                    <path d="M20.5519 94.7771C20.5224 94.7971 20.3966 94.6222 20.1654 94.5717C19.9346 94.519 19.7465 94.6233 19.7281 94.5927C19.7186 94.5793 19.7531 94.5314 19.8359 94.4886C19.917 94.4459 20.0504 94.4149 20.1934 94.447C20.3361 94.4789 20.4437 94.5637 20.499 94.637C20.5556 94.711 20.5664 94.7691 20.5519 94.7771Z" fill="#0C2B34"/>
                    <path d="M20.553 93.8885C20.5209 93.9039 20.4253 93.7334 20.224 93.6586C20.0236 93.5814 19.8392 93.646 19.8251 93.613C19.8177 93.5983 19.8555 93.5584 19.9368 93.53C20.0166 93.5018 20.1427 93.4912 20.2693 93.5391C20.396 93.5868 20.4832 93.6781 20.5242 93.7525C20.5665 93.8275 20.5684 93.8824 20.553 93.8885Z" fill="#0C2B34"/>
                    <path d="M20.7705 93.9026C20.7349 93.8937 20.7568 93.7102 20.6697 93.5135C20.5879 93.314 20.4402 93.2031 20.4586 93.1713C20.4686 93.1378 20.6846 93.2196 20.7874 93.4634C20.8924 93.7059 20.802 93.9185 20.7705 93.9026Z" fill="#0C2B34"/>
                    <path d="M21.1148 93.5929C21.0972 93.5939 21.0723 93.4445 21.0462 93.202C21.0334 93.0617 21.0204 92.9205 21.0072 92.7756C21.0048 92.6955 20.9833 92.6149 21.0074 92.5042C21.0213 92.4496 21.0543 92.3943 21.1109 92.3598C21.1675 92.321 21.2581 92.3279 21.3091 92.3676C21.41 92.447 21.439 92.5389 21.4746 92.6255C21.5058 92.7142 21.5219 92.8038 21.5273 92.8888C21.5371 93.0601 21.5004 93.2124 21.4503 93.3295C21.3464 93.567 21.2004 93.6523 21.195 93.6414C21.1779 93.626 21.2935 93.5206 21.3657 93.2974C21.4006 93.187 21.4243 93.0489 21.4095 92.8977C21.4017 92.8229 21.3852 92.745 21.3568 92.6689C21.3284 92.5953 21.2861 92.5079 21.2371 92.4737C21.2128 92.4583 21.197 92.4578 21.1764 92.4691C21.1549 92.4815 21.1362 92.5068 21.1284 92.5368C21.1113 92.5984 21.1239 92.6888 21.125 92.7689C21.1289 92.9137 21.1328 93.056 21.1367 93.1966C21.1395 93.4404 21.1326 93.5918 21.1148 93.5929Z" fill="#0C2B34"/>
                    <path d="M21.1636 93.697C21.1521 93.6894 21.238 93.5623 21.4621 93.489C21.6777 93.4217 22.0577 93.4358 22.2885 93.7842C22.3002 93.8171 22.2978 93.8636 22.2759 93.8967C22.2542 93.931 22.2245 93.9481 22.1993 93.9592C22.1468 93.9813 22.1026 93.982 22.0631 93.9867C21.9809 93.9941 21.9011 93.9933 21.826 93.9861C21.6755 93.9724 21.5441 93.9334 21.4404 93.8881C21.2322 93.7965 21.1356 93.6905 21.1452 93.6796C21.1569 93.6627 21.2699 93.7395 21.472 93.8035C21.5729 93.8349 21.6963 93.862 21.8345 93.8685C21.9035 93.8718 21.9759 93.8703 22.0503 93.8618C22.0885 93.857 22.1258 93.8536 22.1483 93.8425C22.1735 93.8275 22.1666 93.8319 22.1663 93.823C22.1635 93.8089 22.1358 93.779 22.1086 93.7538C22.082 93.7284 22.0531 93.7054 22.0234 93.6857C21.9638 93.6449 21.9 93.6152 21.8364 93.5952C21.7091 93.5545 21.5853 93.5571 21.4846 93.5768C21.281 93.6191 21.1764 93.7137 21.1636 93.697Z" fill="#0C2B34"/>
                    <path d="M18.6544 92.9761C18.6518 92.9761 18.6492 92.9761 18.6466 92.9759C18.456 92.972 18.3046 92.8139 18.3087 92.623C18.3128 92.435 18.4666 92.2851 18.6538 92.2851C18.6566 92.2851 18.659 92.2851 18.6618 92.2853C18.8524 92.2892 19.0038 92.4473 18.9997 92.6382C18.9954 92.8263 18.8418 92.9761 18.6544 92.9761Z" fill="#F9BAB8"/>
                    <path d="M50.7131 91.6993L50.6737 95.5118C50.6737 95.5118 54.7336 97.0212 54.7948 97.7266H47.2017L47.0195 91.7837L50.7131 91.6993Z" fill="#DE5757"/>
                    <path d="M48.4776 95.8383C48.3538 95.8383 48.2306 95.7493 48.1994 95.6276C48.1649 95.4932 48.2458 95.3411 48.3731 95.2873C48.4022 95.2708 48.4349 95.2637 48.4685 95.2637C48.5846 95.2637 48.7136 95.3502 48.7544 95.4574C48.8073 95.596 48.6874 95.7888 48.5447 95.8291C48.5228 95.8352 48.5002 95.8383 48.4776 95.8383Z" fill="#F9BAB8"/>
                    <path d="M54.8079 97.7249H47.2148H54.8079C54.7945 97.57 54.5882 97.3763 54.2741 97.1681L54.3084 97.1683C54.3084 97.1683 54.8394 97.4921 54.8079 97.7249Z" fill="white"/>
                    <path d="M54.8079 97.7677H47.2148L47.22 97.168L54.2741 97.2109C54.5882 97.4191 54.7944 97.6128 54.8079 97.7677Z" fill="#F9BAB8"/>
                    <path d="M50.8083 95.4896C50.8081 95.5258 50.6279 95.5469 50.453 95.6675C50.2754 95.7835 50.1878 95.9423 50.1541 95.9288C50.1207 95.9228 50.1691 95.7056 50.3832 95.5629C50.5958 95.4187 50.8153 95.4564 50.8083 95.4896Z" fill="#0C2B34"/>
                    <path d="M51.5992 95.8144C51.6083 95.8491 51.4534 95.9146 51.3346 96.0705C51.2114 96.2228 51.1847 96.3887 51.1487 96.3881C51.1149 96.3946 51.0845 96.1838 51.2357 95.9927C51.3853 95.8007 51.5974 95.7801 51.5992 95.8144Z" fill="#0C2B34"/>
                    <path d="M52.0511 96.7237C52.0184 96.7323 51.9635 96.5532 52.0514 96.353C52.1375 96.1521 52.306 96.0699 52.322 96.0997C52.3429 96.1287 52.2361 96.2376 52.1667 96.4031C52.0934 96.5666 52.0869 96.7191 52.0511 96.7237Z" fill="#0C2B34"/>
                    <path d="M50.7171 94.6036C50.7028 94.6368 50.536 94.5913 50.3321 94.6103C50.128 94.6253 49.971 94.6978 49.9512 94.6674C49.9298 94.642 50.0814 94.5043 50.3217 94.4852C50.5618 94.4641 50.7342 94.5748 50.7171 94.6036Z" fill="#0C2B34"/>
                    <path d="M47.0907 93.19L47.0703 92.5783H47.0718L47.0907 93.19Z" fill="#A8ABAB"/>
                    <path d="M47.0892 93.2197L47.0703 92.608L50.7307 92.4805L50.7244 93.1598L47.0892 93.2197Z" fill="#CC5749"/>
                    <path d="M50.745 93.834C50.7459 93.849 50.6038 93.8748 50.3746 93.8416C50.2607 93.8249 50.126 93.7913 49.984 93.7325C49.9133 93.703 49.8406 93.6674 49.7686 93.6251C49.7339 93.6039 49.6931 93.5831 49.6545 93.5408C49.6135 93.5041 49.5883 93.4091 49.633 93.3492C49.6695 93.2913 49.7358 93.2651 49.7892 93.2625C49.8436 93.2592 49.8881 93.2692 49.9287 93.2781C50.0113 93.2959 50.0894 93.3215 50.1609 93.3512C50.3039 93.4119 50.4206 93.4902 50.508 93.5666C50.6837 93.7212 50.7457 93.8546 50.7336 93.862C50.7175 93.8741 50.6312 93.7633 50.4531 93.6366C50.3644 93.5737 50.2516 93.5091 50.1182 93.4588C50.0512 93.4343 49.9796 93.4134 49.9037 93.3987C49.825 93.3803 49.7582 93.3813 49.7391 93.4167C49.7321 93.4304 49.7313 93.4356 49.7482 93.4579C49.766 93.4787 49.7981 93.4987 49.8321 93.5195C49.8987 93.5605 49.9653 93.5959 50.0306 93.6264C50.1614 93.687 50.2857 93.7277 50.3922 93.7544C50.6056 93.8082 50.7453 93.8145 50.745 93.834Z" fill="#0C2B34"/>
                    <path d="M50.696 93.9071C50.6834 93.9129 50.6086 93.7854 50.5893 93.5518C50.5801 93.4359 50.5886 93.2952 50.6296 93.1451C50.6502 93.0705 50.6793 92.9935 50.7181 92.9178C50.7595 92.8438 50.8098 92.7447 50.9493 92.725C51.0226 92.7202 51.0848 92.7757 51.1067 92.8243C51.1325 92.8735 51.1384 92.9165 51.1482 92.959C51.164 93.0449 51.1644 93.1297 51.1549 93.2084C51.1358 93.3665 51.0744 93.4991 51.0065 93.5952C50.8669 93.7904 50.7172 93.8374 50.714 93.8253C50.7014 93.8073 50.8254 93.7344 50.9313 93.5474C50.9835 93.4553 51.0289 93.3342 51.0395 93.1965C51.0451 93.1277 51.0423 93.0551 51.0274 92.9826C51.0137 92.9043 50.9827 92.8416 50.9534 92.8505C50.9167 92.8508 50.8558 92.9117 50.8272 92.975C50.7907 93.0425 50.7623 93.111 50.7404 93.1783C50.6975 93.313 50.6806 93.4416 50.678 93.5496C50.6736 93.7669 50.7155 93.9012 50.696 93.9071Z" fill="#0C2B34"/>
                    <path d="M30.6135 83.6382C30.8736 83.6382 32.1186 88.7156 32.1186 88.7156L20.6055 90.432L21.3358 95.0229C21.3358 95.0229 34.9296 94.1143 35.8603 93.9022C37.5186 93.5241 38.7703 91.921 38.7161 89.8175C38.6534 87.3962 37.2368 81.6896 37.2368 81.6896L30.6135 83.6382Z" fill="#0C2B34"/>
                    <path d="M35.6227 86.3058C34.9377 86.3058 34.215 86.2909 33.5881 86.2462C31.7074 86.1117 31.1523 84.9569 31.1523 84.9569L37.8329 84.4728L38.2118 86.2462C38.2118 86.2462 36.9926 86.3058 35.6227 86.3058Z" fill="#011721"/>
                    <path d="M52.0848 79.7785C51.9343 77.6976 50.1468 76.1131 48.0602 76.1112L46.0133 76.1094L34.9479 76.6818L28.9428 74.8536C28.9428 74.8536 26.8553 78.5873 28.0558 81.7072C28.8102 83.668 30.4769 84.9842 32.4685 85.3234C34.9678 85.7487 46.4228 83.339 46.4228 83.339V93.5418L51.6195 93.408L52.095 79.9779C52.0928 79.9113 52.0898 79.8447 52.0848 79.7785Z" fill="#0C2B34"/>
                    <path d="M46.4094 83.3494C46.4096 83.3512 46.3866 83.3572 46.3415 83.367C46.2901 83.3772 46.2237 83.3909 46.1402 83.4076C45.9554 83.4423 45.6956 83.4911 45.3646 83.5533C44.6825 83.6761 43.7086 83.8518 42.5078 84.0682C41.2988 84.2819 39.8627 84.5357 38.2687 84.8174C37.4705 84.9573 36.6328 85.1039 35.7648 85.2562C34.8946 85.4117 33.9719 85.4824 33.0336 85.4113C32.5644 85.3766 32.1031 85.3059 31.658 85.1933C31.2153 85.0773 30.7802 84.9393 30.3863 84.7255C29.5927 84.3064 28.9866 83.6542 28.5533 82.9655C28.1167 82.2738 27.8451 81.5325 27.7082 80.8204C27.5679 80.1074 27.5644 79.4238 27.6349 78.8123C27.8102 77.5912 28.1375 76.6455 28.3882 76.0076C28.5162 75.6889 28.6307 75.448 28.7136 75.2877C28.7552 75.2072 28.7888 75.1471 28.8125 75.1074C28.8363 75.0675 28.8496 75.0478 28.8515 75.0489C28.8533 75.0497 28.8431 75.0712 28.8225 75.1126C28.8001 75.1599 28.7706 75.2209 28.7342 75.2974C28.658 75.4608 28.5505 75.7039 28.4292 76.0236C28.1924 76.6622 27.8774 77.6122 27.7143 78.8212C27.6497 79.4261 27.6579 80.1007 27.8002 80.8024C27.939 81.5034 28.2095 82.2313 28.6411 82.9098C29.0699 83.5859 29.6645 84.2209 30.4381 84.6279C30.821 84.835 31.2487 84.9703 31.6853 85.0842C32.1235 85.1946 32.5787 85.2647 33.0423 85.2989C33.9695 85.3688 34.8816 85.3002 35.7461 85.1471C36.6146 84.997 37.4527 84.8526 38.2511 84.7148C39.8467 84.4422 41.2841 84.1964 42.4941 83.9895C43.6973 83.788 44.6736 83.6245 45.357 83.5102C45.6895 83.4568 45.9507 83.4149 46.1363 83.3854C46.2207 83.3731 46.2877 83.3631 46.3394 83.3557C46.3853 83.3497 46.409 83.3475 46.4094 83.3494Z" fill="#335863"/>
                    <path d="M32.7614 94.2263C32.7614 94.228 32.7426 94.2308 32.7057 94.235C32.6632 94.2391 32.6087 94.2445 32.5404 94.2512C32.3881 94.2638 32.1741 94.2816 31.9001 94.3042C31.3349 94.3467 30.5232 94.408 29.5088 94.4844C27.463 94.6299 24.6012 94.8334 21.3064 95.0674L21.2566 95.0709L21.2487 95.0214C21.06 93.8396 20.8588 92.5781 20.6514 91.2782C20.6059 90.9912 20.5605 90.706 20.5167 90.4309L20.5078 90.3745L20.5642 90.3663C25.3349 89.6651 29.5062 89.0521 32.0808 88.6736L32.0908 88.6721L32.0997 88.6766C32.8929 89.0668 33.4529 89.492 33.813 89.8019C33.993 89.9581 34.1225 90.0878 34.2075 90.177C34.2461 90.2197 34.2769 90.2537 34.3014 90.2806C34.322 90.3047 34.332 90.3171 34.3307 90.3182C34.3296 90.3192 34.3175 90.3086 34.2949 90.2871C34.2689 90.2615 34.2361 90.2294 34.1949 90.1893C34.106 90.1045 33.973 89.9796 33.7906 89.8282C33.4256 89.5282 32.8621 89.1137 32.0715 88.7348L32.0903 88.7378C29.5172 89.1267 25.3486 89.7568 20.5807 90.4778L20.628 90.4132C20.672 90.6884 20.7173 90.9736 20.7629 91.2604C20.9692 92.5605 21.1694 93.8222 21.3568 95.0043L21.2991 94.9583C24.5947 94.7401 27.4575 94.5506 29.504 94.415C30.5193 94.3521 31.3318 94.3018 31.8975 94.2666C32.1721 94.2519 32.3864 94.2402 32.5389 94.2319C32.6076 94.2291 32.6623 94.2269 32.7048 94.2252C32.7421 94.2243 32.7612 94.2246 32.7614 94.2263Z" fill="#335863"/>
                    <path d="M47.5636 82.0848C47.5764 82.1172 47.1879 82.241 46.86 82.5959C46.5255 82.9451 46.4258 83.3403 46.3928 83.3296C46.3796 83.3266 46.385 83.2236 46.4392 83.067C46.4928 82.9106 46.6034 82.7043 46.7776 82.5184C46.9524 82.3334 47.1517 82.2102 47.3042 82.1473C47.4573 82.0838 47.5597 82.0718 47.5636 82.0848Z" fill="#335863"/>
                    <path d="M38.2789 76.519C38.2795 76.5268 38.1696 76.5427 37.9702 76.5641C37.7707 76.5867 37.4811 76.6088 37.123 76.6288C36.407 76.6704 35.4164 76.69 34.3235 76.7015C33.2305 76.7138 32.2414 76.729 31.5274 76.7691C31.1702 76.7869 30.8817 76.8095 30.6821 76.826C30.4832 76.844 30.3722 76.8505 30.3711 76.8424C30.37 76.8349 30.4787 76.814 30.6771 76.7824C30.8756 76.7522 31.1643 76.7175 31.5222 76.6893C32.2375 76.6288 33.2288 76.6008 34.3222 76.5884C35.4154 76.5769 36.4044 76.57 37.1198 76.549C37.4612 76.5375 37.7455 76.5277 37.967 76.5203C38.1672 76.5123 38.2782 76.5114 38.2789 76.519Z" fill="#335863"/>
                    <path d="M36.0833 60.4004L35.9694 60.5383C34.4413 60.8238 33.2 62.0395 32.776 63.5355C32.3545 65.0219 32.2265 67.7735 31.3646 71.5012C31.3646 71.5012 29.2494 73.4155 28.8555 74.8545L34.9638 76.6975L38.298 76.5105L39.5843 72.5104C40.8325 72.5104 41.3639 71.8849 41.8123 70.8622C42.4092 69.5005 40.4419 63.2505 40.4419 63.2505L40.5831 64.3181L36.0833 60.4004Z" fill="#DE5757"/>
                    <path d="M41.8797 68.8317C41.8797 68.8317 41.3145 65.8983 41.3086 65.6738L42.7915 68.6925L41.8797 68.8317Z" fill="#CC5749"/>
                    <path d="M40.1837 72.4923C40.1806 72.4806 40.2902 72.4585 40.4713 72.378C40.6519 72.2989 40.9005 72.1481 41.1441 71.893C41.3859 71.6384 41.6172 71.2764 41.7579 70.8328C41.8996 70.3895 41.9384 69.8689 41.8987 69.3306C41.857 68.7905 41.751 68.2823 41.6495 67.8211C41.5469 67.3598 41.4536 66.9425 41.3957 66.5878C41.3376 66.2332 41.3122 65.9428 41.3076 65.7417C41.3024 65.5406 41.3131 65.4296 41.3193 65.4298C41.3287 65.4298 41.333 65.5404 41.3514 65.7391C41.3695 65.9376 41.4068 66.2237 41.4744 66.5737C41.5419 66.9238 41.6425 67.3368 41.751 67.7979C41.8583 68.2589 41.969 68.7718 42.0113 69.3223C42.0518 69.8711 42.0093 70.4066 41.857 70.8649C41.7057 71.3228 41.4588 71.6926 41.2014 71.949C40.9419 72.2056 40.678 72.3503 40.488 72.4188C40.3921 72.4522 40.317 72.4743 40.2641 72.4823C40.2121 72.4925 40.1845 72.496 40.1837 72.4923Z" fill="#0C2B34"/>
                    <path d="M38.9648 74.411L39.0579 74.121L39.0065 74.3737C39.0065 74.3737 38.9922 74.3876 38.9648 74.411Z" fill="#A8ABAB"/>
                    <path d="M37.7608 74.8454C37.3925 74.8454 36.9674 74.7244 36.5184 74.3635C35.1704 73.2796 33.1055 66.1622 33.1055 66.1622L39.272 73.1202L39.0739 74.0926L38.9809 74.3826C38.8442 74.4986 38.3842 74.8454 37.7608 74.8454Z" fill="#CC5749"/>
                    <path d="M52.5711 65.6161C52.3349 65.4059 52.197 65.4812 52.197 65.4812C52.197 65.4812 52.3228 64.9055 52.0226 64.7031C51.9304 64.6411 51.8801 64.6086 51.8536 64.5925C51.8217 64.5164 51.6365 64.1028 51.3268 64.0318C51.3268 64.0318 51.2847 63.4913 51.0567 63.4408C50.624 63.3451 50.4436 63.8069 50.4436 63.8069L49.6644 65.2948L49.2925 66.806L42.918 69.7751L43.601 72.6992L50.7565 69.0026L52.0337 67.7784C52.0337 67.7784 52.8076 65.8265 52.5711 65.6161Z" fill="#F9B299"/>
                    <path d="M33.543 64.0106C33.5352 64.2383 37.1416 73.6297 38.8449 74.2858C39.4928 74.5352 49.3112 70.8553 49.3112 70.8553L48.117 67.2367C48.117 67.2367 41.2488 69.5437 41.0209 69.5357C40.7931 69.5279 38.6458 63.5848 38.6458 63.5848C38.6458 63.5848 37.2977 60.7659 35.2751 61.6444C33.98 62.207 33.543 64.0106 33.543 64.0106Z" fill="#DE5757"/>
                    <path d="M41.039 69.5648C41.039 69.5648 41.0813 69.5462 41.1657 69.5164C41.2557 69.4854 41.3802 69.4427 41.5398 69.3878C41.8747 69.2759 42.3567 69.1154 42.969 68.9113C44.2108 68.5037 45.9811 67.9229 48.1204 67.221L48.1649 67.2064L48.1798 67.2509C48.544 68.3482 48.9494 69.5696 49.3799 70.8677L49.396 70.9161L49.3485 70.9343C47.8076 71.5284 46.1197 72.1633 44.3515 72.7916C43.2709 73.1749 42.2122 73.54 41.1787 73.861C40.661 74.0178 40.1528 74.1737 39.6413 74.2857C39.5142 74.3156 39.3877 74.3455 39.2563 74.359L39.062 74.3852C38.9978 74.3965 38.9203 74.3846 38.8548 74.3681C38.5896 74.2809 38.4039 74.0905 38.231 73.9104C37.8922 73.5369 37.6282 73.1257 37.3814 72.724C37.1374 72.3199 36.9181 71.918 36.7144 71.5252C36.3075 70.7398 35.9611 69.9925 35.6544 69.3065C35.0434 67.9331 34.5942 66.803 34.2901 66.0198C34.1385 65.6281 34.0244 65.3224 33.949 65.1146C33.9134 65.0144 33.8856 64.9359 33.8648 64.8774C33.8466 64.8236 33.8383 64.7958 33.8401 64.7949C33.842 64.7943 33.854 64.821 33.8756 64.8732C33.8991 64.9309 33.9303 65.0081 33.9702 65.1064C34.055 65.3172 34.176 65.6185 34.3309 66.0035C34.6474 66.7813 35.1079 67.9064 35.7273 69.2737C36.0381 69.9567 36.3884 70.7009 36.7975 71.482C37.0023 71.8724 37.2224 72.272 37.4662 72.6724C37.7124 73.0701 37.9768 73.4775 38.3074 73.8395C38.4735 74.0141 38.6596 74.1948 38.8843 74.2659C38.9913 74.303 39.116 74.267 39.242 74.2529C39.3671 74.2401 39.4923 74.2102 39.6183 74.1805C40.1226 74.069 40.6304 73.9122 41.1462 73.7553C42.1767 73.4335 43.2341 73.0682 44.3138 72.6851C46.0804 72.0574 47.7688 71.4247 49.3099 70.8348L49.2784 70.9011C48.852 69.6017 48.451 68.379 48.0905 67.2804L48.1495 67.3106C46.005 67.9966 44.2305 68.5645 42.9859 68.9627C42.3699 69.1566 41.8854 69.3089 41.5487 69.4149C41.3871 69.4639 41.2613 69.5023 41.17 69.5301C41.0843 69.5553 41.039 69.5648 41.039 69.5648Z" fill="#0C2B34"/>
                    <path d="M35.8398 61.5913C35.8396 61.5874 35.8739 61.5828 35.9396 61.5776C36.0053 61.5727 36.1025 61.5696 36.2279 61.5755C36.4749 61.5909 36.8517 61.6362 37.2454 61.8709C37.4421 61.9852 37.6297 62.1555 37.8045 62.3522C37.9822 62.5485 38.1531 62.7736 38.3168 63.0209C38.6485 63.5161 38.9112 64.1136 39.1899 64.7331C39.7328 65.9829 40.1275 67.1511 40.4047 67.9975C40.5427 68.4211 40.6494 68.7653 40.7214 69.0037C40.793 69.2423 40.829 69.3752 40.8216 69.3778C40.814 69.3802 40.7639 69.2518 40.6795 69.0176C40.5908 68.7653 40.4724 68.4298 40.329 68.0231C40.0327 67.1839 39.6267 66.0224 39.0864 64.7782C38.8081 64.1603 38.55 63.566 38.2297 63.0777C38.0709 62.8328 37.9054 62.6092 37.7345 62.4144C37.5646 62.2175 37.39 62.0533 37.2035 61.939C36.8317 61.705 36.4671 61.6475 36.2246 61.6193C35.9784 61.5959 35.8401 61.6011 35.8398 61.5913Z" fill="#0C2B34"/>
                    <path d="M51.3414 64.0148C51.3685 64.0302 51.288 64.2224 51.1618 64.444C51.0356 64.6655 50.9113 64.8327 50.8842 64.8171C50.8571 64.8017 50.9373 64.6095 51.0637 64.3881C51.19 64.1664 51.3142 63.9994 51.3414 64.0148Z" fill="#F79570"/>
                    <path d="M51.7648 64.5524C51.7904 64.5708 51.6971 64.7424 51.5767 64.9484C51.4559 65.1541 51.352 65.3193 51.3232 65.3061C51.2952 65.2935 51.3555 65.1024 51.4793 64.8912C51.6027 64.6799 51.74 64.5342 51.7648 64.5524Z" fill="#F79570"/>
                    <path d="M52.2293 65.4797C52.2573 65.4931 52.2204 65.6276 52.1469 65.7801C52.0732 65.9325 51.9908 66.0453 51.9626 66.0317C51.9344 66.0182 51.9715 65.8835 52.0452 65.731C52.1189 65.5786 52.2014 65.4658 52.2293 65.4797Z" fill="#F79570"/>
                    <path d="M41.0744 69.4345C41.1021 69.4538 40.8896 69.7813 40.7325 70.2301C40.5716 70.6776 40.5304 71.0661 40.4968 71.0632C40.4682 71.0641 40.4593 70.6578 40.626 70.1924C40.7898 69.7258 41.0527 69.4159 41.0744 69.4345Z" fill="#0C2B34"/>
                    <path d="M43.0094 36.7271L41.3 36.0352C41.3 36.0352 41.0109 36.4573 41.4744 36.8792C41.9379 37.3013 42.4899 37.5448 42.4899 37.5448C42.4899 37.5448 42.6847 38.4125 43.1231 38.8551C43.5612 39.2981 44.5513 38.6001 44.5513 38.6001C44.5513 38.6001 44.5513 37.3024 43.0094 36.7271Z" fill="#D88875"/>
                    <path d="M45.5805 42.2976C45.377 42.0117 45.1734 42.1816 45.1734 42.1816C45.1734 42.1816 45.4143 41.5742 45.1222 41.299C45.0326 41.2146 44.9831 41.1697 44.9571 41.1476C44.9361 41.0584 44.8072 40.5728 44.4812 40.4396C44.4812 40.4396 44.4788 39.8679 44.2368 39.7759C43.8529 39.6299 43.4232 40.0674 43.4232 40.0674L42.4356 41.5228L40.9648 43.9638L41.7845 46.5692L44.1173 45.1164L44.5819 44.6662C44.5819 44.6662 45.818 42.6314 45.5805 42.2976Z" fill="#FCCBB6"/>
                    <path d="M44.5139 40.3823C44.5404 40.3986 44.4682 40.5636 44.3528 40.7508C44.2372 40.938 44.122 41.0764 44.0953 41.0601C44.0688 41.0436 44.1411 40.8788 44.2567 40.6914C44.3721 40.5044 44.4875 40.3658 44.5139 40.3823Z" fill="#F8A891"/>
                    <path d="M44.9559 41.0648C44.9845 41.0703 44.9383 41.3501 44.742 41.6309C44.5475 41.9131 44.3015 42.0541 44.2865 42.0292C44.2666 42.0027 44.4679 41.8307 44.6492 41.5665C44.8333 41.3043 44.924 41.0555 44.9559 41.0648Z" fill="#F8A891"/>
                    <path d="M45.1833 42.0907C45.2113 42.1026 45.1629 42.2725 45.0311 42.4408C44.9001 42.61 44.7472 42.6982 44.7289 42.6742C44.7088 42.6492 44.8205 42.5286 44.9419 42.3714C45.0647 42.2152 45.1541 42.0775 45.1833 42.0907Z" fill="#F8A891"/>
                    <path d="M40.7227 38.9725C41.0012 39.3057 41.3595 39.5716 41.759 39.7418C41.9212 39.811 42.1002 39.8653 42.2726 39.8277C42.4453 39.7904 42.6025 39.6334 42.5836 39.4579C42.5698 39.3282 42.4702 39.2265 42.3765 39.136C42.1186 38.8873 41.8607 38.6387 41.6028 38.3899C41.6931 38.5248 41.785 38.6617 41.9106 38.7645C42.036 38.8671 42.2026 38.9322 42.3613 38.8994C42.5201 38.8667 42.6576 38.7153 42.6392 38.5541C42.6277 38.4539 42.5626 38.3691 42.5004 38.2899C42.1644 37.8639 41.8284 37.4379 41.4924 37.0119" fill="#D88875"/>
                    <path d="M42.5568 39.5799C42.5626 39.5804 42.5687 39.6177 42.5427 39.6782C42.5171 39.7385 42.4529 39.8133 42.3535 39.8706C42.2546 39.9272 42.1245 39.9751 41.969 39.9765C41.8137 39.9775 41.6501 39.9216 41.5029 39.8363C40.9118 39.4832 40.6513 38.9731 40.6776 38.9657C40.7047 38.9425 41.0008 39.4066 41.5588 39.7381C41.6961 39.8175 41.8386 39.868 41.9707 39.8723C42.1019 39.8771 42.2245 39.842 42.3164 39.7999C42.5108 39.7155 42.5418 39.5747 42.5568 39.5799Z" fill="#915A53"/>
                    <path d="M42.5971 38.7019C42.6027 38.7041 42.5978 38.7397 42.5633 38.7941C42.5312 38.8503 42.4492 38.9132 42.3357 38.9399C42.1073 38.9887 41.7868 38.9141 41.5094 38.7089C41.24 38.4907 41.0938 38.2161 40.9975 38.0241C40.9038 37.8285 40.8602 37.7025 40.8734 37.6957C40.8879 37.6881 40.9574 37.8029 41.0678 37.9857C41.1795 38.1653 41.3341 38.4223 41.5785 38.6197C41.8275 38.8052 42.1247 38.8863 42.321 38.8614C42.5255 38.8351 42.5795 38.6872 42.5971 38.7019Z" fill="#915A53"/>
                    <path d="M42.3341 39.8522C42.3374 39.8465 42.3768 39.8565 42.4306 39.9047C42.4827 39.9515 42.5506 40.042 42.5625 40.1767C42.5753 40.3094 42.5109 40.4799 42.3569 40.579C42.1988 40.6827 41.9836 40.6597 41.8081 40.5923C41.4492 40.4582 41.1813 40.2274 41.0249 40.0383C40.8672 39.8472 40.8104 39.7036 40.8217 39.6978C40.8373 39.6882 40.9178 39.8151 41.0841 39.9845C41.2492 40.1528 41.511 40.3606 41.847 40.486C42.0107 40.5487 42.1825 40.5638 42.3022 40.4903C42.4235 40.4187 42.4842 40.2866 42.4827 40.1801C42.4827 40.0702 42.4356 39.9849 42.3983 39.9342C42.3597 39.8828 42.3293 39.8598 42.3341 39.8522Z" fill="#915A53"/>
                    <path d="M43.5058 38.9908C43.5105 39.0023 43.2537 38.9889 42.9854 38.7186C42.8538 38.5865 42.7351 38.3915 42.661 38.1579C42.6234 38.0415 42.5959 37.9152 42.5774 37.7853C42.5686 37.7224 42.5577 37.6619 42.5302 37.6192C42.5054 37.5771 42.4553 37.5517 42.3918 37.5229C42.1434 37.4086 41.8983 37.2956 41.7062 37.1389C41.5107 36.9852 41.3886 36.7878 41.3229 36.6151C41.2548 36.441 41.2507 36.2815 41.276 36.1798C41.3014 36.077 41.342 36.0323 41.3461 36.0354C41.3554 36.0397 41.3298 36.0907 41.3194 36.187C41.309 36.2828 41.3242 36.426 41.3966 36.5848C41.468 36.7433 41.5864 36.9194 41.7706 37.0572C41.953 37.1988 42.189 37.3055 42.4393 37.4205C42.4989 37.4478 42.5794 37.4836 42.6252 37.5593C42.6692 37.6311 42.6777 37.7057 42.687 37.7697C42.7037 37.8966 42.7275 38.0159 42.7603 38.1271C42.8254 38.3497 42.9286 38.5341 43.044 38.6644C43.2782 38.9301 43.5147 38.9722 43.5058 38.9908Z" fill="#915A53"/>
                    <path d="M48.8791 59.1848L50.2093 58.1543C50.2093 58.1543 50.5678 58.4536 50.265 58.9388C49.9623 59.424 49.5378 59.7746 49.5378 59.7746C49.5378 59.7746 49.5809 60.5847 49.3055 61.082C49.03 61.5794 47.9876 61.2111 47.9876 61.2111C47.9876 61.2111 47.667 60.0711 48.8791 59.1848Z" fill="#F9B299"/>
                    <path d="M50.9134 60.497C50.7323 60.7521 50.5358 61.0191 50.2584 61.1642C50.1454 61.223 49.9738 61.2169 49.8476 61.2C49.7216 61.1829 49.5997 61.0788 49.6029 60.9517C49.6055 60.8577 49.6715 60.7788 49.7337 60.7085C49.9051 60.515 50.0762 60.3216 50.2476 60.1281C50.1903 60.2302 50.1322 60.3339 50.0476 60.4148C49.9632 60.4957 49.8472 60.5519 49.7311 60.5374C49.6151 60.5231 49.5077 60.422 49.5118 60.3051C49.5144 60.2324 49.5563 60.1676 49.5966 60.1073C49.814 59.7819 50.0313 59.4566 50.2486 59.131" fill="#F9B299"/>
                    <path d="M50.9028 60.9863C50.7664 61.2627 50.5382 61.4928 50.263 61.6316C50.1546 61.6863 50.0294 61.7277 49.9132 61.693C49.8108 61.6624 49.7294 61.5709 49.711 61.4657C49.6928 61.3605 49.7383 61.2468 49.8244 61.1835" fill="#F9B299"/>
                    <path d="M49.8171 61.1839C49.8314 61.1946 49.7297 61.2705 49.7401 61.4277C49.7464 61.5006 49.7965 61.587 49.8832 61.6282C49.9676 61.6702 50.0841 61.6512 50.1971 61.5976C50.4283 61.4898 50.6042 61.3288 50.7148 61.2013C50.8259 61.0727 50.8801 60.979 50.8957 60.9868C50.9083 60.9922 50.8788 61.1009 50.7779 61.2501C50.6777 61.3976 50.4977 61.5822 50.2441 61.7004C50.1201 61.7598 49.9609 61.79 49.8357 61.7208C49.7145 61.6548 49.6574 61.5308 49.6603 61.4306C49.6626 61.3297 49.7093 61.2599 49.7459 61.2234C49.7839 61.1863 49.8132 61.1783 49.8171 61.1839Z" fill="#F79570"/>
                    <path d="M49.6652 60.9498C49.6806 60.9453 49.7134 61.0388 49.855 61.0841C49.9225 61.1071 50.0112 61.1238 50.1019 61.1123C50.1934 61.1012 50.2899 61.0579 50.383 60.9939C50.761 60.7269 50.953 60.3826 50.9816 60.4013C51.0087 60.4089 50.8558 60.7965 50.4465 61.0874C50.3441 61.1578 50.2268 61.2084 50.1121 61.2158C49.9967 61.2231 49.8993 61.1945 49.8236 61.1574C49.7479 61.1199 49.6969 61.0672 49.6759 61.0234C49.6548 60.9791 49.659 60.9511 49.6652 60.9498Z" fill="#F79570"/>
                    <path d="M49.5609 60.4409C49.5769 60.4283 49.6268 60.5257 49.7698 60.5287C49.9075 60.5324 50.1131 60.4567 50.2779 60.312C50.4393 60.1595 50.5373 59.9682 50.6096 59.8344C50.6809 59.6982 50.7282 59.6132 50.743 59.6195C50.7568 59.6251 50.7365 59.7197 50.6827 59.8672C50.6265 60.0123 50.5384 60.2203 50.3541 60.3955C50.1626 60.5621 49.9329 60.6335 49.7613 60.6083C49.6761 60.5938 49.6121 60.5502 49.586 60.5096C49.5587 60.4704 49.5552 60.4439 49.5609 60.4409Z" fill="#F79570"/>
                    <path d="M49.0241 61.2848C49.011 61.2692 49.2071 61.1729 49.3459 60.8822C49.4143 60.7395 49.4587 60.5528 49.4607 60.3417C49.462 60.2361 49.4533 60.1257 49.4364 60.0105C49.429 59.9515 49.4177 59.8836 49.4388 59.8081C49.4609 59.7288 49.5238 59.6765 49.5693 59.6379C49.7609 59.4752 49.9415 59.3234 50.0665 59.1546C50.1938 58.9889 50.2543 58.8058 50.2784 58.6495C50.3029 58.4926 50.2814 58.3638 50.2495 58.2822C50.2172 58.2003 50.1827 58.1614 50.1901 58.1547C50.1936 58.1504 50.2408 58.1794 50.289 58.2636C50.3374 58.3467 50.3738 58.4881 50.3575 58.6586C50.3428 58.8271 50.2844 59.0316 50.1506 59.2158C50.02 59.4017 49.8326 59.5617 49.6429 59.7235C49.5938 59.7648 49.5572 59.7986 49.5466 59.84C49.5333 59.8832 49.5385 59.9383 49.5461 59.9955C49.562 60.1146 49.5691 60.2326 49.5648 60.3443C49.557 60.5684 49.5004 60.7697 49.4169 60.9187C49.2466 61.2228 49.0232 61.2972 49.0241 61.2848Z" fill="#F79570"/>
                    <path d="M39.4323 23.6104C39.4445 23.6093 39.4918 23.8273 39.5069 24.1908C39.5106 24.3721 39.5026 24.5938 39.4286 24.8298C39.3902 24.9454 39.3425 25.0708 39.2419 25.1768C39.1922 25.2289 39.1252 25.2729 39.0484 25.292C38.9727 25.312 38.8792 25.302 38.8096 25.2543C38.6693 25.1551 38.6298 25.0048 38.5949 24.8792C38.5636 24.7513 38.5398 24.6278 38.522 24.5088C38.4862 24.2708 38.4754 24.0541 38.4767 23.8728C38.4812 23.5095 38.5298 23.2894 38.543 23.2911C38.5608 23.293 38.5407 23.5149 38.5565 23.8713C38.5654 24.0492 38.5842 24.2606 38.6248 24.4921C38.645 24.6077 38.6706 24.7287 38.702 24.8517C38.7335 24.9699 38.7797 25.0987 38.8708 25.1595C38.9595 25.2206 39.0866 25.1801 39.1629 25.0992C39.2434 25.0176 39.292 24.9044 39.3297 24.797C39.4039 24.5797 39.4206 24.3676 39.4271 24.1908C39.4325 23.8353 39.4135 23.6114 39.4323 23.6104Z" fill="#F8A891"/>
                    <path d="M40.1938 24.1699C40.2085 24.1704 40.2224 24.2901 40.2194 24.4864C40.2126 24.6794 40.1946 24.9642 40.0387 25.2386C39.9994 25.3056 39.9567 25.3687 39.899 25.4227C39.8428 25.4761 39.765 25.5182 39.683 25.5169C39.516 25.5073 39.4251 25.3815 39.3895 25.2854C39.329 25.0826 39.3659 24.9625 39.3739 24.962C39.3954 24.9579 39.3928 25.0894 39.4631 25.2542C39.4984 25.3299 39.5834 25.4147 39.6824 25.4128C39.7802 25.4113 39.8723 25.3035 39.9411 25.182C40.0812 24.9371 40.1137 24.669 40.1398 24.4803C40.163 24.2894 40.1773 24.1693 40.1938 24.1699Z" fill="#F8A891"/>
                    <path d="M37.8481 27.6281C38.5369 27.191 37.96 24.8494 37.5307 24.2989C38.0016 23.8215 38.2172 23.2857 37.8815 22.7053C37.4457 23.1397 36.7089 23.6796 36.5742 24.875L36.7089 25.7864L37.8481 27.6281Z" fill="#FCCBB6"/>
                    <path d="M37.9896 26.6644C37.9701 26.6592 38.0558 26.4278 38.061 26.0421C38.069 25.6615 37.9556 25.1153 37.5871 24.6572C37.5146 24.5655 37.4363 24.4815 37.3557 24.4074L37.3047 24.3605L37.3611 24.3208C37.5628 24.1785 37.7098 23.9885 37.7994 23.799C37.8903 23.6087 37.9233 23.4196 37.9283 23.2621C37.9352 22.9439 37.8502 22.7593 37.8686 22.7541C37.8743 22.7518 37.9007 22.794 37.9322 22.8797C37.9627 22.9652 37.9968 23.0953 38.0018 23.2621C38.0066 23.4278 37.9805 23.6322 37.8888 23.8397C37.7986 24.0462 37.6439 24.2549 37.4255 24.4117L37.4309 24.3252C37.5164 24.4024 37.5994 24.4906 37.6756 24.5872C38.064 25.0696 38.1705 25.6519 38.1408 26.0447C38.1289 26.2439 38.0916 26.4013 38.0586 26.5067C38.0246 26.6122 37.9964 26.6666 37.9896 26.6644Z" fill="#F8A891"/>
                </svg>
                <div class="first-widget-title"><?php esc_html_e("Congratulations! 🎉", "chaty"); ?></div>
                <div class="first-widget-desc"><?php esc_html_e("Your first widget is now up and running on your website!", "chaty"); ?></div>
                <div class="upgrade-features">
                    <div class="upgrade-feature-title"><?php esc_html_e("Upgrade to Pro today", "chaty"); ?></div>
                    <ul>
                        <li><?php esc_html_e("📱 Create multiple widgets for different devices, pages and languages.", "chaty"); ?></li>
                        <li><?php esc_html_e("💬 Show multiple agents under a single channel.", "chaty"); ?></li>
                        <li><?php esc_html_e("📈 Unlock analytics about each channel usage and different widgets.", "chaty"); ?></li>
                        <li><?php esc_html_e("🎨 Customise the widget to display the chat view popup.", "chaty"); ?></li>
                    </ul>
                </div>
                <div class="upgrade-footer">
                    <a class="popup-upgrade-button" href="<?php echo esc_url(admin_url("admin.php?page=chaty-app-upgrade")) ?>"><?php esc_html_e("Upgrade to Pro", "chaty"); ?></a>
                    <div>
                        <a class="popup-dashboard-button" href="<?php echo esc_url(admin_url("admin.php?page=chaty-app")) ?>">
                            <?php esc_html_e("Close", "chaty"); ?>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 12L10 8L6 4" stroke="#5F5DE4" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
} else {
    $showFirstChatyLeadBox = get_option("show_first_chaty_lead_box");
    if ($showFirstChatyLeadBox == 1) {
        update_option("show_first_chaty_lead_box", 2);
        ?>
        <div class="first-chaty-popup">
            <div class="first-chaty-popup-overlay"></div>
            <div class="first-chaty-popup-content chaty-lead">
                <div class="first-chaty-popup-data">
                    <a href="#" class="close-first-popup">
                        <img src="<?php echo esc_url(CHT_PLUGIN_URL) ?>admin/assets/images/x.svg" alt="chaty" />
                    </a>
                    <a href="<?php echo esc_url( $this->getDashboardUrl() ) ?>">
                        <img class="mx-auto" src="<?php echo esc_url(CHT_PLUGIN_URL) ?>admin/assets/images/logo-color.svg" alt="chaty" />
                    </a>
                    <div class="first-title"><?php esc_html_e("Congratulations", "chaty"); ?> 👏</div>
                    <div class="first-des p-50">
                        <p><?php echo sprintf(esc_html__("You just got your first lead from Chaty. Click on the %1\$s button to display your contact form leads", "chaty"), "<b>".esc_html__("Show me", "chaty")."</b>") ?></p>
                        <p><?php echo sprintf(esc_html__("%1\$s to get leads to your email along with advanced triggers & targeting & more cool features", "chaty"), "<b>".esc_html__("Upgrade to Chaty Pro 🚀", "chaty")."</b>") ?></p>
                    </div>
                    <div class="show-lead-btn">
                        <a href="<?php echo esc_url(admin_url("admin.php?page=chaty-contact-form-feed")) ?>" class=""><?php esc_html_e("Show me the new lead", "chaty") ?></a><span class="dashicons dashicons-arrow-right"></span>
                    </div>
                    <div class="first-button lead-btn">
                        <a target="_blank" href="<?php echo esc_url(admin_url("admin.php?page=chaty-app-upgrade")) ?>"><?php esc_html_e("Upgrade to Pro", "chaty"); ?><span>🚀</span></a>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }//end if
}//end if
?>
<script>
    jQuery(document).ready(function(){
        jQuery(document).on("click", ".close-first-popup", function(e){
            e.preventDefault();
            jQuery(this).closest(".first-chaty-popup").hide();
        });
        jQuery(document).on("click", ".first-chaty-popup-overlay", function(e){
            jQuery(".first-chaty-popup").hide();
        });
        jQuery(document).on("click", ".first-chaty-popup-content", function(e){
            e.stopPropagation();
        });
    })
</script>
